/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;

public final class TemplateRecordHeader {
    public static final int SIZE = 4;
    public final int templateId;
    public final int fieldCount;

    public TemplateRecordHeader(ByteBuf buffer) throws InvalidPacketException {
        this.templateId = BufferUtils.uint16((ByteBuf)buffer);
        if (this.templateId <= 255 && this.templateId != 2) {
            throw new InvalidPacketException(buffer, "Invalid template ID: %d", this.templateId);
        }
        this.fieldCount = BufferUtils.uint16((ByteBuf)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("templateId", this.templateId).add("fieldCount", this.fieldCount).toString();
    }
}

