/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix;

import java.io.Closeable;
import java.util.Optional;
import org.opennms.core.ipc.twin.api.TwinPublisher;
import org.opennms.core.ipc.twin.api.TwinSubscriber;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementXmlProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Semantics;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.xml.Element;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.xml.IpfixDotD;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.xml.IpfixElements;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.InformationElementProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInformationElementXmlProvider
implements InformationElementXmlProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInformationElementXmlProvider.class);
    public static final String TWIN_KEY = "ipfix-dot-d.config";
    protected InformationElementDatabase database;
    protected TwinSubscriber twinSubscriber;
    protected TwinPublisher.Session<IpfixDotD> twinSession;
    protected Closeable twinSubscription;

    public AbstractInformationElementXmlProvider(TwinSubscriber twinSubscriber) {
        this.twinSubscriber = twinSubscriber;
    }

    @Override
    public InformationElementDatabase getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(InformationElementDatabase database) {
        this.database = database;
    }

    protected void applyConfig(InformationElementDatabase.Adder adder, IpfixDotD ipfixDotD) {
        if (ipfixDotD == null) {
            return;
        }
        LOG.info("Applying new config...");
        adder.clear(this.getClass().getName());
        for (IpfixElements ipfixElements : ipfixDotD.getIpfixElements()) {
            long vendor = ipfixElements.getScope().getPen();
            for (Element element : ipfixElements.getElements()) {
                int id = element.getId();
                String name = element.getName();
                InformationElementDatabase.ValueParserFactory valueParserFactory = InformationElementProvider.TYPE_LOOKUP.get(element.getDataType());
                adder.add(Protocol.IPFIX, Optional.of(vendor), id, valueParserFactory, name, Optional.of(Semantics.DEFAULT), this.database, this.getClass().getName());
            }
        }
    }

    @Override
    public void load(InformationElementDatabase.Adder adder) {
        this.twinSubscription = this.twinSubscriber.subscribe(TWIN_KEY, IpfixDotD.class, config -> this.applyConfig(adder, (IpfixDotD)config));
    }
}

