/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class ProviderFileLoader
implements ProviderLoader {
    private static final Logger LOGGER = Logger.getLogger(ProviderFileLoader.class.getName());
    private Collection<IQProviderInfo> iqProviders;
    private Collection<ExtensionProviderInfo> extProviders;
    private List<Exception> exceptions = new LinkedList<Exception>();

    public ProviderFileLoader(InputStream providerStream) {
        this(providerStream, ProviderFileLoader.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderFileLoader(InputStream providerStream, ClassLoader classLoader) {
        this.iqProviders = new ArrayList<IQProviderInfo>();
        this.extProviders = new ArrayList<ExtensionProviderInfo>();
        try {
            XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(providerStream, "UTF-8");
            int eventType = parser.getEventType();
            do {
                if (eventType != 2) continue;
                String typeName = parser.getName();
                try {
                    if ("smackProviders".equals(typeName)) continue;
                    parser.next();
                    parser.next();
                    String elementName = parser.nextText();
                    parser.next();
                    parser.next();
                    String namespace = parser.nextText();
                    parser.next();
                    parser.next();
                    String className = parser.nextText();
                    try {
                        Class<?> provider = classLoader.loadClass(className);
                        if ("iqProvider".equals(typeName)) {
                            if (IQProvider.class.isAssignableFrom(provider)) {
                                this.iqProviders.add(new IQProviderInfo(elementName, namespace, (IQProvider)provider.newInstance()));
                                continue;
                            }
                            if (!IQ.class.isAssignableFrom(provider)) continue;
                            this.iqProviders.add(new IQProviderInfo(elementName, namespace, provider));
                            continue;
                        }
                        if (PacketExtensionProvider.class.isAssignableFrom(provider)) {
                            this.extProviders.add(new ExtensionProviderInfo(elementName, namespace, (PacketExtensionProvider)provider.newInstance()));
                            continue;
                        }
                        if (!PacketExtension.class.isAssignableFrom(provider)) continue;
                        this.extProviders.add(new ExtensionProviderInfo(elementName, namespace, provider));
                    }
                    catch (ClassNotFoundException cnfe) {
                        LOGGER.log(Level.SEVERE, "Could not find provider class", cnfe);
                        this.exceptions.add(cnfe);
                    }
                }
                catch (IllegalArgumentException illExc) {
                    LOGGER.log(Level.SEVERE, "Invalid provider type found [" + typeName + "] when expecting iqProvider or extensionProvider", illExc);
                    this.exceptions.add(illExc);
                }
            } while ((eventType = parser.next()) != 1);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unknown error occurred while parsing provider file", e);
            this.exceptions.add(e);
        }
        finally {
            try {
                providerStream.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Collection<IQProviderInfo> getIQProviderInfo() {
        return this.iqProviders;
    }

    @Override
    public Collection<ExtensionProviderInfo> getExtensionProviderInfo() {
        return this.extProviders;
    }

    public List<Exception> getLoadingExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }
}

