/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.zenithconnect.rest.impl;

import javax.ws.rs.core.Response;
import org.opennms.features.zenithconnect.persistence.api.ZenithConnectPersistenceException;
import org.opennms.features.zenithconnect.persistence.api.ZenithConnectPersistenceService;
import org.opennms.features.zenithconnect.persistence.api.ZenithConnectRegistration;
import org.opennms.features.zenithconnect.persistence.api.ZenithConnectRegistrations;
import org.opennms.features.zenithconnect.rest.api.ZenithConnectRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultZenithConnectRestService
implements ZenithConnectRestService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultZenithConnectRestService.class);
    private final ZenithConnectPersistenceService persistenceService;

    public DefaultZenithConnectRestService(ZenithConnectPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public Response getRegistrations() {
        try {
            ZenithConnectRegistrations registrations = this.persistenceService.getRegistrations();
            return Response.ok((Object)registrations).build();
        }
        catch (ZenithConnectPersistenceException e) {
            LOG.error("Could not get registrations, error retrieving or parsing registrations: {}.", (Object)e.getMessage(), (Object)e);
            return Response.serverError().build();
        }
    }

    @Override
    public Response addRegistration(ZenithConnectRegistration registration) {
        try {
            ZenithConnectRegistration newRegistration = this.persistenceService.addRegistration(registration, true);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)newRegistration).build();
        }
        catch (ZenithConnectPersistenceException e) {
            LOG.error("Could not add registration: {}. Attempted to add duplicate: {}", new Object[]{e.getMessage(), e.isAttemptedToAddDuplicate(), e});
            if (e.isAttemptedToAddDuplicate()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return Response.serverError().build();
        }
    }

    @Override
    public Response updateRegistration(String id, ZenithConnectRegistration registration) {
        try {
            this.persistenceService.updateRegistration(id, registration);
            return Response.ok().build();
        }
        catch (ZenithConnectPersistenceException e) {
            LOG.error("Could not update registration: {}.", (Object)e.getMessage(), (Object)e);
            return Response.serverError().build();
        }
    }

    @Override
    public Response deleteRegistration(String id) {
        try {
            this.persistenceService.deleteRegistration(id);
            return Response.ok().build();
        }
        catch (ZenithConnectPersistenceException e) {
            LOG.error("Could not delete registration: {}.", (Object)e.getMessage(), (Object)e);
            return Response.serverError().build();
        }
    }
}

