/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample.health;

import java.util.Comparator;
import java.util.Optional;
import org.opennms.integration.api.sample.health.ServiceExtensionHealthCheck;
import org.opennms.integration.api.v1.collectors.ServiceCollectorClient;
import org.opennms.integration.api.v1.dao.NodeDao;
import org.opennms.integration.api.v1.detectors.DetectorClient;
import org.opennms.integration.api.v1.health.Context;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.opennms.integration.api.v1.health.immutables.ImmutableResponse;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.pollers.ServicePollerClient;

public class ServiceExtensionOnMinionHealthCheck
extends ServiceExtensionHealthCheck {
    public ServiceExtensionOnMinionHealthCheck(DetectorClient detectorClient, ServicePollerClient pollerClient, ServiceCollectorClient collectorClient, NodeDao nodeDao) {
        super(detectorClient, pollerClient, collectorClient, nodeDao);
    }

    @Override
    public String getDescription() {
        return "OIA :: Sample Project :: Service Extensions on Minion";
    }

    @Override
    public Response perform(Context context) {
        Optional<Node> maybeMinion = this.getNodeDao().getNodesInForeignSource("Minions").stream().sorted(Comparator.comparing(Node::getId).reversed()).findFirst();
        if (!maybeMinion.isPresent()) {
            return ImmutableResponse.newInstance((Status)Status.Unknown, (String)"No Minion found in MINION requisition.");
        }
        return this.verifyExtensionsAtLocation(maybeMinion.get().getLocation());
    }
}

