/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.opennms.integration.api.v1.pollers.PollerRequest;
import org.opennms.integration.api.v1.pollers.PollerResult;
import org.opennms.integration.api.v1.pollers.ServicePoller;
import org.opennms.integration.api.v1.pollers.Status;
import org.opennms.integration.api.v1.pollers.immutables.ImmutablePollerResult;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplePoller
implements ServicePoller {
    private static final Logger LOG = LoggerFactory.getLogger(SamplePoller.class);
    private final RuntimeInfo runtimeInfo;

    public SamplePoller(RuntimeInfo runtimeInfo) {
        this.runtimeInfo = Objects.requireNonNull(runtimeInfo);
    }

    public CompletableFuture<PollerResult> poll(PollerRequest pollerRequest) {
        CompletableFuture<PollerResult> future = new CompletableFuture<PollerResult>();
        LOG.info("{} service is Up", (Object)pollerRequest.getServiceName());
        future.complete((PollerResult)ImmutablePollerResult.newBuilder().setStatus(Status.Up).addProperty("location", (Number)Objects.hash(this.runtimeInfo.getSystemLocation())).build());
        return future;
    }
}

