/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;

public class SystemIDMigratorOffline
extends AbstractOnmsUpgrade {
    @Override
    public int getOrder() {
        return 15;
    }

    @Override
    public String getDescription() {
        return "Updates OpenNMS system ID to a random UUID.";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        block22: {
            try (Connection connection = DataSourceFactory.getInstance().getConnection();
                 Statement preExecutionStatement = connection.createStatement();
                 ResultSet resultSet = preExecutionStatement.executeQuery("SELECT id FROM monitoringsystems WHERE location='Default' AND type='OpenNMS'");){
                if (resultSet.next()) {
                    String systemID = resultSet.getString("id");
                    if (systemID == null || !systemID.equals("00000000-0000-0000-0000-000000000000")) {
                        throw new OnmsUpgradeException("id is not set to the default, not updating");
                    }
                    break block22;
                }
                throw new OnmsUpgradeException("No entries found in monitoringsystems table");
            }
            catch (SQLException e) {
                throw new OnmsUpgradeException("Error opening database connection", e);
            }
        }
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        try (Connection c = DataSourceFactory.getInstance().getConnection();
             Statement st = c.createStatement();){
            String newUUID = UUID.randomUUID().toString();
            try {
                c.setAutoCommit(false);
                st.addBatch("ALTER TABLE alarms DROP CONSTRAINT fk_alarms_systemid");
                st.addBatch("ALTER TABLE alarms ADD CONSTRAINT fk_alarms_systemid FOREIGN KEY (systemId) REFERENCES monitoringsystems (id) ON UPDATE CASCADE ON DELETE CASCADE");
                st.addBatch("UPDATE monitoringsystems SET id='" + newUUID + "' WHERE id='00000000-0000-0000-0000-000000000000' AND location='Default' AND type='OpenNMS'");
                st.addBatch("ALTER TABLE alarms DROP CONSTRAINT fk_alarms_systemid");
                st.addBatch("ALTER TABLE alarms ADD CONSTRAINT fk_alarms_systemid FOREIGN KEY (systemId) REFERENCES monitoringsystems (id) ON DELETE CASCADE");
                st.addBatch("UPDATE events SET systemid='" + newUUID + "' WHERE systemid = '00000000-0000-0000-0000-000000000000'");
                st.executeBatch();
                c.commit();
            }
            catch (SQLException e) {
                c.rollback();
                throw e;
            }
        }
        catch (SQLException e) {
            throw new OnmsUpgradeException("unable to update systemId", e);
        }
    }
}

