/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.service.Attribute;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.ServiceConfiguration;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;
import org.xml.sax.InputSource;

public class ServiceConfigMigratorOffline
extends AbstractOnmsUpgrade {
    private ServiceConfiguration baseConfig;
    private File configFile;
    private boolean skipMe = false;

    public ServiceConfigMigratorOffline() throws OnmsUpgradeException {
        try {
            this.configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SERVICE_CONF_FILE_NAME);
            InputSource src = new InputSource(this.getClass().getResourceAsStream("/default/service-configuration-14.0.0.xml"));
            this.baseConfig = (ServiceConfiguration)JaxbUtils.unmarshal(ServiceConfiguration.class, (InputSource)src);
        }
        catch (IOException e) {
            throw new OnmsUpgradeException("Can't find Services Configuration file", e);
        }
    }

    @Override
    public int getOrder() {
        return 6;
    }

    @Override
    public String getDescription() {
        return "Fixes service-configuration.xml if necessary when upgrading from 1.12: NMS-6970";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        if (this.isInstalledVersionGreaterOrEqual(14, 0, 0)) {
            this.log("This upgrade procedure should only run against systems older than 14.0.0; the current version is " + this.getOpennmsVersion() + "\n", new Object[0]);
            this.skipMe = true;
            return;
        }
        try {
            this.log("Backing up %s\n", this.configFile);
            this.zipFile(this.configFile);
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't backup service-configurations.xml because " + e.getMessage());
        }
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
        if (this.skipMe) {
            return;
        }
        File zip = new File(this.configFile.getAbsolutePath() + ".zip");
        if (zip.exists()) {
            this.log("Removing backup %s\n", zip);
            FileUtils.deleteQuietly((File)zip);
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        if (this.skipMe) {
            return;
        }
        this.log("Restoring backup %s\n", this.configFile);
        File zip = new File(this.configFile.getAbsolutePath() + ".zip");
        FileUtils.deleteQuietly((File)this.configFile);
        this.unzipFile(zip, zip.getParentFile());
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        if (this.skipMe) {
            return;
        }
        try {
            ServiceConfiguration currentCfg = (ServiceConfiguration)JaxbUtils.unmarshal(ServiceConfiguration.class, (File)this.configFile);
            int index = 0;
            for (Service baseSvc : this.baseConfig.getServices()) {
                Attribute a;
                Service localSvc = ServiceConfigMigratorOffline.getService(currentCfg, baseSvc.getName());
                if (localSvc == null) {
                    if (baseSvc.isEnabled().booleanValue()) {
                        this.log("Adding new service %s\n", baseSvc.getName());
                    } else {
                        this.log("Marking service %s as disabled\n", baseSvc.getName());
                    }
                    currentCfg.getServices().add(index, baseSvc);
                    continue;
                }
                if (!baseSvc.isEnabled().booleanValue()) {
                    this.log("Disabling service %s because it is not on the default list of enabled services\n", localSvc.getName());
                    localSvc.setEnabled(Boolean.valueOf(false));
                }
                if (localSvc.getClassName().equals("org.opennms.netmgt.poller.jmx.RemotePollerBackEnd")) {
                    this.log("Fixing the class path for RemotePollerBackEnd.\n", new Object[0]);
                    localSvc.setClassName("org.opennms.netmgt.poller.remote.jmx.RemotePollerBackEnd");
                }
                if (localSvc.getName().equals("OpenNMS:Name=Linkd")) {
                    this.log("Disabling Linkd (to promote EnhancedLinkd)\n", new Object[0]);
                    localSvc.setEnabled(Boolean.valueOf(false));
                }
                if ((a = ServiceConfigMigratorOffline.getLoggingPrefix(localSvc)) != null) {
                    String prefix = a.getValue().getContent().toLowerCase();
                    if (!a.getValue().getContent().equals(prefix)) {
                        this.log("Fixing logging prefix for service %s\n", localSvc.getName());
                        a.getValue().setContent(prefix);
                    }
                }
                ++index;
            }
            StringWriter sw = new StringWriter();
            sw.write("<?xml version=\"1.0\"?>\n");
            sw.write("<!-- NOTE!!!!!!!!!!!!!!!!!!!\n");
            sw.write("The order in which these services are specified is important - for example, Eventd\n");
            sw.write("will need to come up last so that none of the event topic subcribers loose any event.\n");
            sw.write("\nWhen splitting services to run on mutiple VMs, the order of the services should be\n");
            sw.write("maintained\n");
            sw.write("-->\n");
            JaxbUtils.marshal((Object)currentCfg, (Writer)sw);
            FileWriter fw = new FileWriter(this.configFile);
            fw.write(sw.toString());
            fw.close();
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't fix services configuration because " + e.getMessage(), e);
        }
    }

    private static Service getService(ServiceConfiguration svcConfig, String serviceName) {
        for (Service s : svcConfig.getServices()) {
            if (!s.getName().equals(serviceName)) continue;
            return s;
        }
        return null;
    }

    private static Attribute getLoggingPrefix(Service svc) {
        for (Attribute a : svc.getAttributes()) {
            if (!a.getName().equals("LoggingPrefix")) continue;
            return a;
        }
        return null;
    }
}

