/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.ticketing.inmemory;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.features.ticketing.inmemory.TicketMapper;
import org.opennms.features.ticketing.inmemory.TicketStateNameCompleter;

@Command(scope="opennms", name="inmemory-ticketer", description="Queries/Update tickets from InMemoryTicketer")
@Service
public class InMemoryTicketerShellCommand
implements Action {
    @Reference
    private TicketMapper ticketMapper;
    @Option(name="-t", aliases={"--ticketId"}, description="Specify ticketId", required=true)
    private String ticketId;
    @Argument(index=0, name="setState", description="Set Ticket state")
    @Completion(value=TicketStateNameCompleter.class, caseSensitive=false)
    private Ticket.State ticketState;

    public Object execute() throws Exception {
        if (this.ticketId == null) {
            throw new IllegalArgumentException("ticketId required");
        }
        Ticket ticket = this.ticketMapper.getTicket(this.ticketId);
        if (ticket == null) {
            System.out.printf("Not able to find ticket with id %s in InMemoryTicketer \n ", this.ticketId);
            return null;
        }
        if (this.ticketState != null) {
            ticket.setState(this.ticketState);
            this.ticketMapper.updateTicket(ticket);
            System.out.printf("Updated ticket with state : %s \n", this.ticketState.name());
        }
        System.out.printf("Ticket Details for ticketId %s :\n", this.ticketId);
        System.out.println(ticket);
        return null;
    }
}

