/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.IpNetToMediaDao;
import org.opennms.netmgt.enlinkd.service.api.IpNetToMediaTopologyService;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class IpNetToMediaTopologyServiceImpl
implements IpNetToMediaTopologyService {
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private static final Logger LOG = LoggerFactory.getLogger(IpNetToMediaTopologyServiceImpl.class);
    private IpNetToMediaDao m_ipNetToMediaDao;
    private IpInterfaceDao m_ipInterfaceDao;

    @Override
    public void delete(int nodeid) {
        this.m_ipNetToMediaDao.deleteBySourceNodeId(nodeid);
        this.m_ipNetToMediaDao.flush();
    }

    @Override
    public void reconcile(int nodeId, Date now) {
        this.m_ipNetToMediaDao.deleteBySourceNodeIdOlderThen(nodeId, now);
        this.m_ipNetToMediaDao.flush();
    }

    @Override
    public void store(int nodeId, IpNetToMedia ipnettomedia) {
        if (ipnettomedia == null) {
            return;
        }
        this.saveIpNetToMedia(nodeId, ipnettomedia);
    }

    @Transactional
    protected void saveIpNetToMedia(final int nodeId, final IpNetToMedia saveMe) {
        new UpsertTemplate<IpNetToMedia, IpNetToMediaDao>(this.m_transactionManager, this.m_ipNetToMediaDao){

            @Override
            protected IpNetToMedia query() {
                return ((IpNetToMediaDao)this.m_dao).getByNetAndPhysAddress(saveMe.getNetAddress(), saveMe.getPhysAddress());
            }

            @Override
            protected IpNetToMedia doUpdate(IpNetToMedia dbIpNetToMedia) {
                OnmsNode sourceNode = new OnmsNode();
                sourceNode.setId(Integer.valueOf(nodeId));
                saveMe.setSourceNode(sourceNode);
                IpNetToMediaTopologyServiceImpl.this.putOnmsPropertyForIpNetToMedia(saveMe);
                dbIpNetToMedia.merge(saveMe);
                ((IpNetToMediaDao)this.m_dao).update(dbIpNetToMedia);
                ((IpNetToMediaDao)this.m_dao).flush();
                return dbIpNetToMedia;
            }

            @Override
            protected IpNetToMedia doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setSourceNode(node);
                IpNetToMediaTopologyServiceImpl.this.putOnmsPropertyForIpNetToMedia(saveMe);
                saveMe.setLastPollTime(saveMe.getCreateTime());
                ((IpNetToMediaDao)this.m_dao).saveOrUpdate(saveMe);
                ((IpNetToMediaDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    private void putOnmsPropertyForIpNetToMedia(IpNetToMedia ipnetToMedia) {
        List<OnmsIpInterface> onmsiplist = this.m_ipInterfaceDao.findByIpAddress(InetAddressUtils.str((InetAddress)ipnetToMedia.getNetAddress()));
        if (onmsiplist.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No OnmsIpInterface found for {}", (Object)ipnetToMedia);
            }
            return;
        }
        if (onmsiplist.size() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found {} OnmsIpInterface for {}", (Object)onmsiplist.size(), (Object)ipnetToMedia);
            }
            List nodeids = onmsiplist.stream().map(OnmsIpInterface::getNodeId).collect(Collectors.toList());
            ipnetToMedia.setPort("Multiple Nodes: " + String.valueOf(nodeids));
            return;
        }
        OnmsIpInterface onmsip = onmsiplist.iterator().next();
        ipnetToMedia.setNode(onmsip.getNode());
        if (onmsip.getSnmpInterface() == null) {
            ipnetToMedia.setIfIndex(Integer.valueOf(-1));
            return;
        }
        ipnetToMedia.setIfIndex(onmsip.getIfIndex());
        ipnetToMedia.setPort(Topology.getPortTextString(SnmpInterfaceTopologyEntity.create((OnmsSnmpInterface)onmsip.getSnmpInterface())));
    }

    public IpNetToMediaDao getIpNetToMediaDao() {
        return this.m_ipNetToMediaDao;
    }

    public void setIpNetToMediaDao(IpNetToMediaDao ipNetToMediaDao) {
        this.m_ipNetToMediaDao = ipNetToMediaDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }
}

