/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.Closeable;
import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.dao.api.FilterWatcher;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceRef;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.filter.api.FilterDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

@EventListener(name="FilterWatcher")
public class DefaultFilterWatcher
implements FilterWatcher,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFilterWatcher.class);
    private static final String MATCH_ANY_RULE = "IPADDR != '0.0.0.0'";
    private static final String REFRESH_RATE_LIMIT_MS_SYS_PROP = "org.opennms.netmgt.dao.support.filterServiceRefreshRateLimitMs";
    private static final long DEFAULT_REFRESH_RATE_LIMIT_MS = TimeUnit.SECONDS.toMillis(30L);
    private static final long REFRESH_RATE_LIMIT_MS = SystemProperties.getLong((String)"org.opennms.netmgt.dao.support.filterServiceRefreshRateLimitMs", (Long)DEFAULT_REFRESH_RATE_LIMIT_MS);
    @Autowired
    private FilterDao filterDao;
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private SessionUtils sessionUtils;
    private long refreshRateLimitMs = REFRESH_RATE_LIMIT_MS;
    private final Timer timer = new Timer("FilterService-Timer");
    private final Map<String, FilterSession> sessionByRule = new ConcurrentHashMap<String, FilterSession>();

    public void afterPropertiesSet() {
        final long timerIntevalMs = Math.min(this.refreshRateLimitMs, TimeUnit.SECONDS.toMillis(5L));
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    DefaultFilterWatcher.this.sessionByRule.values().forEach(s -> {
                        try {
                            s.refreshIfNeeded();
                        }
                        catch (Exception e) {
                            LOG.warn("Error refreshing filter for rule: {}. Will retry again in {}ms.", new Object[]{s.rule, timerIntevalMs, e});
                        }
                    });
                }
                catch (Exception e) {
                    LOG.warn("Error refreshing filter results. Will retry again in {}ms.", (Object)timerIntevalMs, (Object)e);
                }
            }
        }, timerIntevalMs, timerIntevalMs);
    }

    public void destroy() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Closeable watch(String filterRule, Consumer<FilterWatcher.FilterResults> callback) {
        FilterSession session;
        String effectiveFilterRule = StringUtils.isEmpty((String)filterRule) ? MATCH_ANY_RULE : filterRule.trim();
        Map<String, FilterSession> map = this.sessionByRule;
        synchronized (map) {
            session = this.sessionByRule.computeIfAbsent(effectiveFilterRule, x$0 -> new FilterSession((String)x$0));
            session.addCallback(callback);
        }
        return () -> {
            Map<String, FilterSession> map = this.sessionByRule;
            synchronized (map) {
                session.removeCallback(callback);
                this.garbageCollectSessions();
            }
        };
    }

    private void garbageCollectSessions() {
        List sessionsToRemove = this.sessionByRule.values().stream().filter(s -> s.callbacks.isEmpty()).collect(Collectors.toList());
        for (FilterSession session : sessionsToRemove) {
            this.sessionByRule.remove(session.rule);
        }
    }

    @EventHandler(ueis={"uei.opennms.org/nodes/nodeGainedService", "uei.opennms.org/nodes/serviceDeleted", "uei.opennms.org/nodes/nodeCategoryMembershipChanged", "uei.opennms.org/nodes/nodeLocationChanged", "uei.opennms.org/nodes/nodeAdded", "uei.opennms.org/nodes/nodeDeleted", "uei.opennms.org/nodes/nodeGainedInterface", "uei.opennms.org/nodes/interfaceDeleted", "uei.opennms.org/nodes/interfaceReparented", "uei.opennms.org/internal/poller/suspendPollingService", "uei.opennms.org/internal/poller/resumePollingService"})
    public void inventoryChangeEventHandler(IEvent event) {
        this.sessionByRule.values().forEach(FilterSession::requestRefresh);
    }

    public void setRefreshRateLimitMs(long refreshRateLimitMs) {
        this.refreshRateLimitMs = refreshRateLimitMs;
    }

    public long getRefreshRateLimitMs() {
        return this.refreshRateLimitMs;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.filterDao = filterDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public void setSessionUtils(SessionUtils sessionUtils) {
        this.sessionUtils = sessionUtils;
    }

    private class FilterSession {
        private final String rule;
        private final List<Consumer<FilterWatcher.FilterResults>> callbacks = new LinkedList<Consumer<FilterWatcher.FilterResults>>();
        private final AtomicReference<FilterWatcher.FilterResults> lastFilterResultsRef = new AtomicReference();
        private long lastRefreshedMs;
        private long lastRefreshRequestMs;

        public FilterSession(String rule) {
            this.rule = Objects.requireNonNull(rule);
            DefaultFilterWatcher.this.filterDao.validateRule(rule);
        }

        public synchronized void addCallback(Consumer<FilterWatcher.FilterResults> callback) {
            this.callbacks.add(callback);
            if (this.requestRefresh()) {
                return;
            }
            FilterWatcher.FilterResults lastFilterResults = this.lastFilterResultsRef.get();
            if (lastFilterResults != null) {
                callback.accept(lastFilterResults);
            }
        }

        public synchronized void removeCallback(Consumer<FilterWatcher.FilterResults> callback) {
            this.callbacks.remove(callback);
        }

        public synchronized void refreshNow() {
            this.lastRefreshedMs = System.currentTimeMillis();
            LOG.debug("Refreshing results for filter rule: {}", (Object)this.rule);
            FilterWatcher.FilterResults newFilterResults = DefaultFilterWatcher.this.sessionUtils.withReadOnlyTransaction(() -> new FilterResultsImpl(DefaultFilterWatcher.this.filterDao.getNodeIPAddressServiceMap(this.rule), DefaultFilterWatcher.this.nodeDao));
            LOG.debug("Done refreshing results for rule.");
            FilterWatcher.FilterResults lastFilterResults = this.lastFilterResultsRef.get();
            if (Objects.equals(lastFilterResults, newFilterResults)) {
                return;
            }
            this.lastFilterResultsRef.set(newFilterResults);
            this.notifyCallbacks(newFilterResults);
        }

        public synchronized boolean refreshIfNeeded() {
            if (this.lastRefreshRequestMs > 0L && this.lastRefreshRequestMs >= this.lastRefreshedMs && System.currentTimeMillis() - this.lastRefreshedMs >= DefaultFilterWatcher.this.refreshRateLimitMs) {
                this.lastRefreshRequestMs = 0L;
                this.refreshNow();
                return true;
            }
            return false;
        }

        public synchronized boolean requestRefresh() {
            this.lastRefreshRequestMs = System.currentTimeMillis();
            return this.refreshIfNeeded();
        }

        private void notifyCallbacks(FilterWatcher.FilterResults results) {
            this.callbacks.forEach(c -> {
                try {
                    c.accept(results);
                }
                catch (Exception e) {
                    LOG.warn("Error notifying callback: {} for results of filter rule: {}.", new Object[]{c, this.rule, e});
                }
            });
        }
    }

    private static class FilterResultsImpl
    implements FilterWatcher.FilterResults {
        private final Map<Integer, Map<InetAddress, Set<String>>> nodeIpServiceMap;
        private final NodeDao nodeDao;

        public FilterResultsImpl(Map<Integer, Map<InetAddress, Set<String>>> nodeIpServiceMap, NodeDao nodeDao) {
            this.nodeIpServiceMap = Objects.requireNonNull(nodeIpServiceMap);
            this.nodeDao = Objects.requireNonNull(nodeDao);
        }

        @Override
        public Map<Integer, Map<InetAddress, Set<String>>> getNodeIpServiceMap() {
            return this.nodeIpServiceMap;
        }

        @Override
        public Set<ServiceRef> getServicesNamed(String serviceName) {
            LinkedHashSet<ServiceRef> serviceRefs = new LinkedHashSet<ServiceRef>();
            for (Map.Entry<Integer, Map<InetAddress, Set<String>>> nodeEntry : this.nodeIpServiceMap.entrySet()) {
                int nodeId = nodeEntry.getKey();
                for (Map.Entry<InetAddress, Set<String>> interfaceEntry : nodeEntry.getValue().entrySet()) {
                    InetAddress interfaceAddress = interfaceEntry.getKey();
                    if (!interfaceEntry.getValue().contains(serviceName)) continue;
                    serviceRefs.add(new ServiceRef(nodeId, interfaceAddress, serviceName, this.nodeDao.getLocationForId(nodeId)));
                }
            }
            return serviceRefs;
        }
    }
}

