/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.distributed.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.distributed.common.MapBasedAdapterDef;
import org.opennms.netmgt.telemetry.distributed.common.PropertyTree;

public class AdapterDefinitionParser {
    public List<AdapterDefinition> parse(String queueName, PropertyTree propertyTree) {
        Objects.requireNonNull(propertyTree);
        if (propertyTree.getMap("adapters").isEmpty()) {
            return Lists.newArrayList((Object[])new AdapterDefinition[]{new MapBasedAdapterDef(queueName, propertyTree)});
        }
        Map<String, PropertyTree> adapterConfigurations = propertyTree.getSubTrees("adapters");
        List keys = adapterConfigurations.keySet().stream().sorted().collect(Collectors.toList());
        ArrayList<AdapterDefinition> adapters = new ArrayList<AdapterDefinition>();
        for (String eachAdapterPrefix : keys) {
            PropertyTree adapterconfig = adapterConfigurations.get(eachAdapterPrefix);
            MapBasedAdapterDef mapBasedAdapterDef = new MapBasedAdapterDef(queueName, adapterconfig);
            adapters.add(mapBasedAdapterDef);
        }
        return adapters;
    }
}

