/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.privacy.PrivacyList;
import org.jivesoftware.smackx.privacy.PrivacyListListener;
import org.jivesoftware.smackx.privacy.packet.Privacy;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;

public class PrivacyListManager
extends Manager {
    public static final String NAMESPACE = "jabber:iq:privacy";
    private static final PacketFilter PACKET_FILTER = new AndFilter(new PacketFilter[]{new IQTypeFilter(IQ.Type.SET), new PacketExtensionFilter("query", "jabber:iq:privacy")});
    private static final Map<XMPPConnection, PrivacyListManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private final List<PrivacyListListener> listeners = new ArrayList<PrivacyListListener>();

    private PrivacyListManager(final XMPPConnection connection) {
        super(connection);
        instances.put(connection, this);
        connection.addPacketListener(new PacketListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                Privacy privacy = (Privacy)packet;
                List list = PrivacyListManager.this.listeners;
                synchronized (list) {
                    for (PrivacyListListener listener : PrivacyListManager.this.listeners) {
                        for (Map.Entry<String, List<PrivacyItem>> entry : privacy.getItemLists().entrySet()) {
                            String listName = entry.getKey();
                            List<PrivacyItem> items = entry.getValue();
                            if (items.isEmpty()) {
                                listener.updatedPrivacyList(listName);
                                continue;
                            }
                            listener.setPrivacyList(listName, items);
                        }
                    }
                }
                IQ iq = IQ.createResultIQ((IQ)privacy);
                connection.sendPacket((Packet)iq);
            }
        }, PACKET_FILTER);
    }

    private String getUser() {
        return this.connection().getUser();
    }

    public static synchronized PrivacyListManager getInstanceFor(XMPPConnection connection) {
        PrivacyListManager plm = instances.get(connection);
        if (plm == null) {
            plm = new PrivacyListManager(connection);
        }
        return plm;
    }

    private Privacy getRequest(Privacy requestPrivacy) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        requestPrivacy.setType(IQ.Type.GET);
        requestPrivacy.setFrom(this.getUser());
        Privacy privacyAnswer = (Privacy)this.connection().createPacketCollectorAndSend((IQ)requestPrivacy).nextResultOrThrow();
        return privacyAnswer;
    }

    private Packet setRequest(Privacy requestPrivacy) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        requestPrivacy.setType(IQ.Type.SET);
        requestPrivacy.setFrom(this.getUser());
        return this.connection().createPacketCollectorAndSend((IQ)requestPrivacy).nextResultOrThrow();
    }

    private Privacy getPrivacyWithListNames() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy request = new Privacy();
        return this.getRequest(request);
    }

    public PrivacyList getActiveList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacyAnswer = this.getPrivacyWithListNames();
        String listName = privacyAnswer.getActiveName();
        boolean isDefaultAndActive = privacyAnswer.getActiveName() != null && privacyAnswer.getDefaultName() != null && privacyAnswer.getActiveName().equals(privacyAnswer.getDefaultName());
        return new PrivacyList(true, isDefaultAndActive, listName, this.getPrivacyListItems(listName));
    }

    public PrivacyList getDefaultList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacyAnswer = this.getPrivacyWithListNames();
        String listName = privacyAnswer.getDefaultName();
        boolean isDefaultAndActive = privacyAnswer.getActiveName() != null && privacyAnswer.getDefaultName() != null && privacyAnswer.getActiveName().equals(privacyAnswer.getDefaultName());
        return new PrivacyList(isDefaultAndActive, true, listName, this.getPrivacyListItems(listName));
    }

    private List<PrivacyItem> getPrivacyListItems(String listName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy request = new Privacy();
        request.setPrivacyList(listName, new ArrayList<PrivacyItem>());
        Privacy privacyAnswer = this.getRequest(request);
        return privacyAnswer.getPrivacyList(listName);
    }

    public PrivacyList getPrivacyList(String listName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return new PrivacyList(false, false, listName, this.getPrivacyListItems(listName));
    }

    public PrivacyList[] getPrivacyLists() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy privacyAnswer = this.getPrivacyWithListNames();
        Set<String> names = privacyAnswer.getPrivacyListNames();
        PrivacyList[] lists = new PrivacyList[names.size()];
        int index = 0;
        for (String listName : names) {
            boolean isActiveList = listName.equals(privacyAnswer.getActiveName());
            boolean isDefaultList = listName.equals(privacyAnswer.getDefaultName());
            lists[index] = new PrivacyList(isActiveList, isDefaultList, listName, this.getPrivacyListItems(listName));
            ++index;
        }
        return lists;
    }

    public void setActiveListName(String listName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy request = new Privacy();
        request.setActiveName(listName);
        this.setRequest(request);
    }

    public void declineActiveList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy request = new Privacy();
        request.setDeclineActiveList(true);
        this.setRequest(request);
    }

    public void setDefaultListName(String listName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy request = new Privacy();
        request.setDefaultName(listName);
        this.setRequest(request);
    }

    public void declineDefaultList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy request = new Privacy();
        request.setDeclineDefaultList(true);
        this.setRequest(request);
    }

    public void createPrivacyList(String listName, List<PrivacyItem> privacyItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.updatePrivacyList(listName, privacyItems);
    }

    public void updatePrivacyList(String listName, List<PrivacyItem> privacyItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy request = new Privacy();
        request.setPrivacyList(listName, privacyItems);
        this.setRequest(request);
    }

    public void deletePrivacyList(String listName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Privacy request = new Privacy();
        request.setPrivacyList(listName, new ArrayList<PrivacyItem>());
        this.setRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PrivacyListListener listener) {
        List<PrivacyListListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    public boolean isSupported() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(this.connection().getServiceName(), NAMESPACE);
    }

    static {
        XMPPConnection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                PrivacyListManager.getInstanceFor(connection);
            }
        });
    }
}

