/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmarks;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.bookmarks.BookmarkedURL;
import org.jivesoftware.smackx.bookmarks.Bookmarks;
import org.jivesoftware.smackx.iqprivate.PrivateDataManager;

public class BookmarkManager {
    private static final Map<XMPPConnection, BookmarkManager> bookmarkManagerMap = new WeakHashMap<XMPPConnection, BookmarkManager>();
    private PrivateDataManager privateDataManager;
    private Bookmarks bookmarks;
    private final Object bookmarkLock = new Object();

    public static synchronized BookmarkManager getBookmarkManager(XMPPConnection connection) throws XMPPException, SmackException {
        BookmarkManager manager = bookmarkManagerMap.get(connection);
        if (manager == null) {
            manager = new BookmarkManager(connection);
        }
        return manager;
    }

    private BookmarkManager(XMPPConnection connection) throws XMPPException, SmackException {
        this.privateDataManager = PrivateDataManager.getInstanceFor(connection);
        bookmarkManagerMap.put(connection, this);
    }

    public Collection<BookmarkedConference> getBookmarkedConferences() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        return Collections.unmodifiableCollection(this.bookmarks.getBookmarkedConferences());
    }

    public void addBookmarkedConference(String name, String jid, boolean isAutoJoin, String nickname, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        BookmarkedConference bookmark = new BookmarkedConference(name, jid, isAutoJoin, nickname, password);
        List<BookmarkedConference> conferences = this.bookmarks.getBookmarkedConferences();
        if (conferences.contains(bookmark)) {
            BookmarkedConference oldConference = conferences.get(conferences.indexOf(bookmark));
            if (oldConference.isShared()) {
                throw new IllegalArgumentException("Cannot modify shared bookmark");
            }
            oldConference.setAutoJoin(isAutoJoin);
            oldConference.setName(name);
            oldConference.setNickname(nickname);
            oldConference.setPassword(password);
        } else {
            this.bookmarks.addBookmarkedConference(bookmark);
        }
        this.privateDataManager.setPrivateData(this.bookmarks);
    }

    public void removeBookmarkedConference(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        Iterator<BookmarkedConference> it = this.bookmarks.getBookmarkedConferences().iterator();
        while (it.hasNext()) {
            BookmarkedConference conference = it.next();
            if (!conference.getJid().equalsIgnoreCase(jid)) continue;
            if (conference.isShared()) {
                throw new IllegalArgumentException("Conference is shared and can't be removed");
            }
            it.remove();
            this.privateDataManager.setPrivateData(this.bookmarks);
            return;
        }
    }

    public Collection<BookmarkedURL> getBookmarkedURLs() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        return Collections.unmodifiableCollection(this.bookmarks.getBookmarkedURLS());
    }

    public void addBookmarkedURL(String URL2, String name, boolean isRSS) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        BookmarkedURL bookmark = new BookmarkedURL(URL2, name, isRSS);
        List<BookmarkedURL> urls = this.bookmarks.getBookmarkedURLS();
        if (urls.contains(bookmark)) {
            BookmarkedURL oldURL = urls.get(urls.indexOf(bookmark));
            if (oldURL.isShared()) {
                throw new IllegalArgumentException("Cannot modify shared bookmarks");
            }
            oldURL.setName(name);
            oldURL.setRss(isRSS);
        } else {
            this.bookmarks.addBookmarkedURL(bookmark);
        }
        this.privateDataManager.setPrivateData(this.bookmarks);
    }

    public void removeBookmarkedURL(String bookmarkURL) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.retrieveBookmarks();
        Iterator<BookmarkedURL> it = this.bookmarks.getBookmarkedURLS().iterator();
        while (it.hasNext()) {
            BookmarkedURL bookmark = it.next();
            if (!bookmark.getURL().equalsIgnoreCase(bookmarkURL)) continue;
            if (bookmark.isShared()) {
                throw new IllegalArgumentException("Cannot delete a shared bookmark.");
            }
            it.remove();
            this.privateDataManager.setPrivateData(this.bookmarks);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bookmarks retrieveBookmarks() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Object object = this.bookmarkLock;
        synchronized (object) {
            if (this.bookmarks == null) {
                this.bookmarks = (Bookmarks)this.privateDataManager.getPrivateData("storage", "storage:bookmarks");
            }
            return this.bookmarks;
        }
    }

    static {
        PrivateDataManager.addPrivateDataProvider("storage", "storage:bookmarks", new Bookmarks.Provider());
    }
}

