/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.support.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Map;
import org.drools.compiler.kproject.models.QualifierModelImpl;
import org.drools.xml.support.converters.AbstractXStreamConverter;

public class QualifierConverter
extends AbstractXStreamConverter {
    public QualifierConverter() {
        super(QualifierModelImpl.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        QualifierModelImpl qualifier = (QualifierModelImpl)value;
        writer.addAttribute("type", qualifier.getType());
        if (qualifier.getValue() != null) {
            writer.addAttribute("value", qualifier.getValue());
        } else {
            for (Map.Entry entry : qualifier.getArguments().entrySet()) {
                writer.startNode("arg");
                writer.addAttribute("key", (String)entry.getKey());
                writer.addAttribute("value", (String)entry.getValue());
                writer.endNode();
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        final QualifierModelImpl qualifier = new QualifierModelImpl();
        qualifier.setType(reader.getAttribute("type"));
        String value = reader.getAttribute("value");
        if (value != null) {
            qualifier.setValue(value);
        } else {
            this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

                @Override
                public void onNode(HierarchicalStreamReader reader, String name, String value) {
                    if ("arg".equals(name)) {
                        qualifier.addArgument(reader.getAttribute("key"), reader.getAttribute("value"));
                    }
                }
            });
        }
        return qualifier;
    }
}

