/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.pathoutage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultStatus;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.pathoutage.PathOutageVertex;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.model.OnmsSeverity;

public class PathOutageStatusProvider
implements StatusProvider {
    private final GenericPersistenceAccessor persistenceAccessor;

    public PathOutageStatusProvider(GenericPersistenceAccessor genericPersistenceAccessor) {
        this.persistenceAccessor = Objects.requireNonNull(genericPersistenceAccessor);
    }

    public Map<VertexRef, Status> getStatusForVertices(BackendGraph graph, Collection<VertexRef> vertices, Criteria[] criteria) {
        List nodeIds = vertices.stream().filter(v -> v.getNamespace().equals(this.getNamespace())).map(v -> (PathOutageVertex)((Object)v)).map(v -> v.getNodeID()).collect(Collectors.toList());
        if (nodeIds.isEmpty()) {
            return new HashMap<VertexRef, Status>();
        }
        StringBuilder hql = new StringBuilder();
        hql.append("SELECT node.id, max(event.eventSeverity) ");
        hql.append("FROM OnmsOutage as outage ");
        hql.append("LEFT JOIN outage.monitoredService as ifservice ");
        hql.append("LEFT JOIN ifservice.ipInterface as ipinterface ");
        hql.append("LEFT JOIN ipinterface.node as node ");
        hql.append("LEFT JOIN outage.serviceLostEvent as event ");
        hql.append("WHERE node.id in (:nodeIds) ");
        hql.append("AND outage.perspective is null ");
        hql.append("AND outage.serviceRegainedEvent is null ");
        hql.append("GROUP BY node.id");
        ArrayList paramNames = Lists.newArrayList((Object[])new String[]{"nodeIds"});
        ArrayList<ArrayList> paramValues = new ArrayList<ArrayList>();
        paramValues.add(Lists.newArrayList(nodeIds));
        List retvals = this.persistenceAccessor.findUsingNamedParameters(hql.toString(), paramNames.toArray(new String[paramNames.size()]), paramValues.toArray());
        HashedMap mappedAlarms = new HashedMap();
        for (int i = 0; i < retvals.size(); ++i) {
            Integer nodeId = (Integer)((Object[])retvals.get(i))[0];
            Integer severity = Optional.ofNullable((Integer)((Object[])retvals.get(i))[1]).orElse(OnmsSeverity.NORMAL.ordinal());
            mappedAlarms.put(nodeId, OnmsSeverity.get((int)severity));
        }
        Map<VertexRef, Status> status = vertices.stream().map(v -> (PathOutageVertex)((Object)v)).collect(Collectors.toMap(v -> v, arg_0 -> PathOutageStatusProvider.lambda$getStatusForVertices$5((Map)mappedAlarms, arg_0)));
        return status;
    }

    public String getNamespace() {
        return "pathoutage";
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace().equals(namespace);
    }

    private static /* synthetic */ Status lambda$getStatusForVertices$5(Map mappedAlarms, PathOutageVertex v) {
        if (!mappedAlarms.containsKey(v.getNodeID())) {
            return new DefaultStatus(OnmsSeverity.NORMAL.getLabel(), 0L);
        }
        return new DefaultStatus(((OnmsSeverity)mappedAlarms.get(v.getNodeID())).getLabel(), 0L);
    }
}

