/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.header.HeaderAddress;
import io.pkts.packet.sip.header.Parameters;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.AddressParametersHeaderImpl;
import io.pkts.packet.sip.header.impl.ParametersSupport;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;
import java.util.UUID;

public interface AddressParametersHeader
extends SipHeader,
HeaderAddress,
Parameters {
    public static Object[] frame(Buffer buffer) throws SipParseException {
        try {
            Address address = Address.frame(buffer);
            Buffer params = null;
            if (buffer.hasReadableBytes()) {
                params = buffer.slice();
            }
            return new Object[]{address, params};
        }
        catch (IndexOutOfBoundsException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to process the value due to a IndexOutOfBoundsException", e);
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to process the To-header to due an IOException");
        }
    }

    public static <T> Builder<AddressParametersHeader> with(Buffer headerName) throws SipParseException {
        PreConditions.assertNotEmpty(headerName, "The name of the header cannot be null or the empty buffer");
        return new Builder<AddressParametersHeader>(headerName);
    }

    @Override
    public Builder copy();

    @Override
    default public boolean isAddressParametersHeader() {
        return true;
    }

    @Override
    default public AddressParametersHeader toAddressParametersHeader() throws ClassCastException {
        return this;
    }

    public static class Builder<T extends AddressParametersHeader>
    implements SipHeader.Builder<T> {
        private final Buffer name;
        private Address.Builder addressBuilder;
        private Buffer value;
        private ParametersSupport paramSupport;

        protected Builder(Buffer name) {
            this(name, new ParametersSupport(null));
        }

        protected Builder(Buffer name, ParametersSupport params) {
            this.name = name;
            this.paramSupport = params;
        }

        @Override
        public final Builder<T> withValue(Buffer buffer) {
            throw new RuntimeException("Not implemented yet");
        }

        public final Builder<T> withPort(int port) {
            this.ensureBuilder().withPort(port);
            return this;
        }

        public final Builder<T> withUser(Buffer user) {
            this.ensureBuilder().withUser(user);
            return this;
        }

        public final Builder<T> withUser(String user) {
            this.ensureBuilder().withUser(user);
            return this;
        }

        public final Builder<T> withDisplayName(String displayName) {
            this.ensureBuilder().withDisplayName(displayName);
            return this;
        }

        public final Builder<T> withDisplayName(Buffer displayName) {
            this.ensureBuilder().withDisplayName(displayName);
            return this;
        }

        public final Builder<T> withHost(Buffer host) {
            this.ensureBuilder().withHost(host);
            return this;
        }

        public final Builder<T> withHost(String host) {
            this.ensureBuilder().withHost(host);
            return this;
        }

        public Builder<T> withNoTag() throws SipParseException, IllegalArgumentException {
            this.paramSupport.removeParameter(SipParser.TAG);
            return this;
        }

        public Builder<T> withTag(Buffer value) throws SipParseException, IllegalArgumentException {
            PreConditions.assertNotEmpty(value, "The value of the tag parameter cannot be null or the empty buffer");
            this.paramSupport.setParameter(SipParser.TAG, value);
            return this;
        }

        public Builder<T> withTag(String value) throws SipParseException, IllegalArgumentException {
            PreConditions.assertNotEmpty(value, "The value of the tag parameter cannot be null or the empty string");
            this.paramSupport.setParameter(SipParser.TAG, Buffers.wrap((String)value));
            return this;
        }

        public Builder<T> withDefaultTag() throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(SipParser.TAG, Buffers.wrap((String)UUID.randomUUID().toString()));
            return this;
        }

        public Builder<T> withParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder<T> withParameter(String name, String value) throws SipParseException, IllegalArgumentException {
            this.paramSupport.setParameter(name, value);
            return this;
        }

        public Builder<T> withParameters(Buffer params) {
            this.paramSupport = new ParametersSupport(params);
            return this;
        }

        public Builder<T> withNoParameters() {
            this.paramSupport = new ParametersSupport();
            return this;
        }

        public Builder<T> withUriParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
            this.ensureBuilder().withURIParameter(name, value);
            return this;
        }

        public Builder<T> withUriParameter(String name, String value) throws SipParseException, IllegalArgumentException {
            this.ensureBuilder().withURIParameter(name, value);
            return this;
        }

        public Builder<T> withTransport(Buffer transport) throws SipParseException {
            this.ensureBuilder().withTransport(transport);
            return this;
        }

        public Builder<T> withTransport(String transport) throws SipParseException {
            this.ensureBuilder().withTransport(transport);
            return this;
        }

        public Builder<T> withTransportTCP() throws SipParseException {
            this.ensureBuilder().withTransportTCP();
            return this;
        }

        public Builder<T> withTransportUDP() throws SipParseException {
            this.ensureBuilder().withTransportUDP();
            return this;
        }

        public Builder<T> withTransportTLS() throws SipParseException {
            this.ensureBuilder().withTransportTLS();
            return this;
        }

        public Builder<T> withTransportSCTP() throws SipParseException {
            this.ensureBuilder().withTransportSCTP();
            return this;
        }

        public Builder<T> withTransportWS() throws SipParseException {
            this.ensureBuilder().withTransportWS();
            return this;
        }

        public Builder<T> withTransportWSS() throws SipParseException {
            this.ensureBuilder().withTransportWSS();
            return this;
        }

        public final Builder<T> withAddress(Address address) throws SipParseException {
            PreConditions.assertNotNull(address, "Address cannot be null");
            this.addressBuilder = address.copy();
            return this;
        }

        @Override
        public final T build() throws SipParseException {
            if (this.addressBuilder == null) {
                throw new SipParseException("You must specify an address of some sort.");
            }
            Address addressToUse = this.addressBuilder.build();
            Buffer addressBuffer = addressToUse.toBuffer();
            Buffer paramsBuffer = this.paramSupport.toBuffer();
            Buffer headerValue = Buffers.createBuffer((int)(addressBuffer.capacity() + paramsBuffer.capacity()));
            addressBuffer.getBytes(0, headerValue);
            paramsBuffer.getBytes(0, headerValue);
            return this.internalBuild(headerValue, addressToUse, paramsBuffer);
        }

        protected T internalBuild(Buffer rawValue, Address address, Buffer params) {
            return (T)new AddressParametersHeaderImpl(this.name, rawValue, address, params);
        }

        private Address.Builder ensureBuilder() {
            if (this.addressBuilder == null) {
                this.addressBuilder = Address.builder();
            }
            return this.addressBuilder;
        }
    }
}

