/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.rest;

import com.google.common.base.Strings;
import java.text.Collator;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.features.scv.rest.CredentialsDTO;
import org.opennms.features.scv.rest.ScvRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScvRestService
implements ScvRestService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultScvRestService.class);
    private final SecureCredentialsVault scv;
    private final Pattern pattern = Pattern.compile("\\*{2,}");
    private final String MASKED_PASSWORD = "******";

    public DefaultScvRestService(SecureCredentialsVault scv) {
        this.scv = scv;
    }

    @Override
    public Response getCredentials(String alias) {
        try {
            Credentials credentials = this.scv.getCredentials(alias);
            if (credentials == null) {
                return Response.noContent().build();
            }
            if (credentials.getUsername() != null && credentials.getPassword() != null) {
                CredentialsDTO dto = new CredentialsDTO(alias, credentials.getUsername(), "******");
                credentials.getAttributes().forEach((key, value) -> dto.getAttributes().put((String)key, "******"));
                return Response.ok((Object)dto).build();
            }
        }
        catch (Exception e) {
            LOG.error("Exception while adding credentials with alias {} ", (Object)alias, (Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        return Response.noContent().build();
    }

    @Override
    public Response addCredentials(CredentialsDTO credentialsDTO) {
        if (credentialsDTO != null && !Strings.isNullOrEmpty((String)credentialsDTO.getAlias())) {
            Credentials existingCredentials = this.scv.getCredentials(credentialsDTO.getAlias());
            if (existingCredentials != null) {
                Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"alias already exists, use PUT to update").build();
            }
            Credentials credentials = new Credentials(credentialsDTO.getUsername(), credentialsDTO.getPassword(), credentialsDTO.getAttributes());
            try {
                this.scv.setCredentials(credentialsDTO.getAlias(), credentials);
                return Response.accepted().build();
            }
            catch (Exception e) {
                LOG.error("Exception while adding credentials with alias {}", (Object)credentialsDTO.getAlias(), (Object)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid Credentials").build();
    }

    @Override
    public Response editCredentials(String alias, CredentialsDTO credentialsDTO) {
        if (credentialsDTO != null && !Strings.isNullOrEmpty((String)alias) && alias.equals(credentialsDTO.getAlias())) {
            Credentials credentials = this.scv.getCredentials(alias);
            HashMap<String, String> attributes = new HashMap<String, String>(credentialsDTO.getAttributes());
            HashMap existingAttributes = credentials != null ? new HashMap(credentials.getAttributes()) : new HashMap();
            credentialsDTO.getAttributes().forEach((key, value) -> {
                if (!this.pattern.matcher((CharSequence)value).matches()) {
                    attributes.put((String)key, (String)value);
                } else {
                    attributes.put((String)key, (String)existingAttributes.get(key));
                }
            });
            if (this.pattern.matcher(credentialsDTO.getPassword()).matches()) {
                String username = credentials != null ? credentials.getUsername() : null;
                String password = credentials != null ? credentials.getPassword() : null;
                credentials = new Credentials(username, password, attributes);
            } else {
                credentials = new Credentials(credentialsDTO.getUsername(), credentialsDTO.getPassword(), attributes);
            }
            try {
                this.scv.setCredentials(alias, credentials);
                return Response.accepted().build();
            }
            catch (Exception e) {
                LOG.error("Exception while adding credentials with alias {}", (Object)credentialsDTO.getAlias(), (Object)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid Credentials").build();
    }

    @Override
    public Response deleteCredentials(String alias) {
        try {
            this.scv.deleteCredentials(alias);
        }
        catch (Exception e) {
            LOG.error("Exception while deleting credentials with alias {} ", (Object)alias, (Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        return Response.noContent().build();
    }

    @Override
    public Response getAliases() {
        Set aliasSet = this.scv.getAliases();
        TreeSet<Object> aliases = new TreeSet<Object>(Collator.getInstance());
        aliases.addAll(aliasSet);
        return Response.ok(aliases).build();
    }
}

