/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.cache;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opennms.core.cache.Cache;
import org.opennms.core.cache.CacheBuilder;
import org.opennms.core.cache.CacheConfig;
import org.opennms.core.cache.CacheConfigBuilder;
import org.opennms.core.mate.api.ContextKey;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.telemetry.protocols.cache.NodeInfo;
import org.opennms.netmgt.telemetry.protocols.cache.NodeInfoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInfoCacheImpl
implements NodeInfoCache {
    private static final Logger LOG = LoggerFactory.getLogger(NodeInfoCacheImpl.class);
    private final NodeDao nodeDao;
    private final IpInterfaceDao ipInterfaceDao;
    private final InterfaceToNodeCache interfaceToNodeCache;
    private final Cache<NodeMetadataKey, Optional<NodeInfo>> nodeMetadataCache;
    private final Cache<InterfaceToNodeCache.Entry, Optional<NodeInfo>> nodeInfoCache;
    private final Timer nodeLoadTimer;
    private final SessionUtils sessionUtils;

    public NodeInfoCacheImpl(CacheConfig nodeInfoCacheConfig, boolean nodeMetadataEnabled, MetricRegistry metricRegistry, NodeDao nodeDao, IpInterfaceDao ipInterfaceDao, InterfaceToNodeCache interfaceToNodeCache, SessionUtils sessionUtils) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.ipInterfaceDao = Objects.requireNonNull(ipInterfaceDao);
        this.interfaceToNodeCache = Objects.requireNonNull(interfaceToNodeCache);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
        CacheConfig nodeMetadataCacheConfig = new CacheConfigBuilder().withName("nodeMetadataCache").withExpireAfterRead(nodeInfoCacheConfig.getExpireAfterRead().longValue()).withExpireAfterWrite(nodeInfoCacheConfig.getExpireAfterWrite().longValue()).withMaximumSize(nodeInfoCacheConfig.getMaximumSize().longValue()).build();
        this.nodeInfoCache = new CacheBuilder().withConfig(Objects.requireNonNull(nodeInfoCacheConfig)).withCacheLoader((CacheLoader)new CacheLoader<InterfaceToNodeCache.Entry, Optional<NodeInfo>>(){

            public Optional<NodeInfo> load(InterfaceToNodeCache.Entry entry) {
                return NodeInfoCacheImpl.this.getNodeInfo(entry);
            }
        }).build();
        this.nodeMetadataCache = new CacheBuilder().withConfig(nodeMetadataCacheConfig).withCacheLoader((CacheLoader)new CacheLoader<NodeMetadataKey, Optional<NodeInfo>>(){

            public Optional<NodeInfo> load(NodeMetadataKey key) {
                return NodeInfoCacheImpl.this.getNodeInfoFromMetadataContext(key.contextKey, key.value);
            }
        }).build();
        this.nodeLoadTimer = Objects.requireNonNull(metricRegistry).timer("nodeLoadTime");
    }

    @Override
    public Optional<NodeInfo> getNodeInfoFromCache(String location, String ipAddress, ContextKey contextKey, String value) {
        return (Optional)this.sessionUtils.withTransaction(() -> {
            Optional entry;
            Optional nodeDocument = Optional.empty();
            if (contextKey != null && !Strings.isNullOrEmpty((String)value)) {
                NodeMetadataKey metadataKey = new NodeMetadataKey(contextKey, value);
                try {
                    nodeDocument = (Optional)this.nodeMetadataCache.get((Object)metadataKey);
                }
                catch (ExecutionException e) {
                    LOG.error("Error while retrieving NodeDocument from NodeMetadataCache: {}.", (Object)e.getMessage(), (Object)e);
                    throw new RuntimeException(e);
                }
                if (nodeDocument.isPresent()) {
                    return nodeDocument;
                }
            }
            if ((entry = this.interfaceToNodeCache.getFirst(location, InetAddressUtils.addr((String)ipAddress))).isPresent()) {
                try {
                    return (Optional)this.nodeInfoCache.get((Object)((InterfaceToNodeCache.Entry)entry.get()));
                }
                catch (ExecutionException e) {
                    LOG.error("Error while retrieving NodeDocument from NodeInfoCache: {}.", (Object)e.getMessage(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
            return nodeDocument;
        });
    }

    private Optional<NodeInfo> getNodeInfoFromMetadataContext(ContextKey contextKey, String value) {
        List nodes;
        List ifaces;
        try (Timer.Context ctx = this.nodeLoadTimer.time();){
            ifaces = this.ipInterfaceDao.findInterfacesWithMetadata(contextKey.getContext(), contextKey.getKey(), value, true);
        }
        if (!ifaces.isEmpty()) {
            OnmsIpInterface iface = (OnmsIpInterface)ifaces.get(0);
            return this.mapOnmsNodeToNodeDocument(iface.getNode(), iface.getId());
        }
        try (Timer.Context ctx = this.nodeLoadTimer.time();){
            nodes = this.nodeDao.findNodeWithMetaData(contextKey.getContext(), contextKey.getKey(), value, true);
        }
        if (!nodes.isEmpty()) {
            OnmsNode node = (OnmsNode)nodes.get(0);
            return this.mapOnmsNodeToNodeDocument(node, node.getPrimaryInterface().getId());
        }
        return Optional.empty();
    }

    private Optional<NodeInfo> getNodeInfo(InterfaceToNodeCache.Entry entry) {
        OnmsNode onmsNode;
        try (Timer.Context ctx = this.nodeLoadTimer.time();){
            onmsNode = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(entry.nodeId));
        }
        return this.mapOnmsNodeToNodeDocument(onmsNode, entry.interfaceId);
    }

    private Optional<NodeInfo> mapOnmsNodeToNodeDocument(OnmsNode onmsNode, int interfaceId) {
        if (onmsNode != null) {
            NodeInfo nodeDocument = new NodeInfo();
            nodeDocument.setForeignSource(onmsNode.getForeignSource());
            nodeDocument.setForeignId(onmsNode.getForeignId());
            nodeDocument.setNodeId(onmsNode.getId());
            nodeDocument.setInterfaceId(interfaceId);
            nodeDocument.setCategories(onmsNode.getCategories().stream().map(OnmsCategory::getName).collect(Collectors.toList()));
            return Optional.of(nodeDocument);
        }
        return Optional.empty();
    }

    private static class NodeMetadataKey {
        public final ContextKey contextKey;
        public final String value;

        private NodeMetadataKey(ContextKey contextKey, String value) {
            this.contextKey = contextKey;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeMetadataKey that = (NodeMetadataKey)o;
            return Objects.equals(this.contextKey, that.contextKey) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.contextKey, this.value);
        }
    }
}

