/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elastic.client;

import java.io.IOException;
import java.util.Objects;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;
import org.opennms.features.elastic.client.ElasticHealthCheck;
import org.opennms.features.elastic.client.ElasticRestClient;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class RequireConfigurationElasticHealthCheck
extends ElasticHealthCheck {
    private final ConfigurationAdmin configAdmin;
    private final String pid;

    public RequireConfigurationElasticHealthCheck(ElasticRestClient client, String featureName, ConfigurationAdmin configAdmin, String pid) {
        super(client, featureName);
        this.configAdmin = Objects.requireNonNull(configAdmin);
        this.pid = Objects.requireNonNull(pid);
    }

    @Override
    public Response perform(Context context) throws Exception {
        try {
            Configuration configuration = this.configAdmin.getConfiguration(this.pid);
            if (configuration.getProperties() == null) {
                return new Response(Status.Success, "Not configured");
            }
        }
        catch (IOException e) {
            return new Response((Throwable)e);
        }
        return super.perform(context);
    }
}

