/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.net.InetAddress;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="pathoutage")
public class OnmsPathOutage
implements Serializable {
    private static final long serialVersionUID = 2180867754702562743L;
    private int m_nodeId;
    private InetAddress m_criticalPathIp;
    private String m_criticalPathServiceName;
    private OnmsNode m_node;

    public OnmsPathOutage(OnmsNode node, InetAddress criticalPathIp, String criticalPathServiceName) {
        this.m_nodeId = node.getId();
        this.m_node = node;
        this.m_criticalPathIp = criticalPathIp;
        this.m_criticalPathServiceName = criticalPathServiceName;
    }

    public OnmsPathOutage() {
    }

    @OneToOne
    @PrimaryKeyJoinColumn
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Id
    @Column(name="nodeId")
    @GeneratedValue(generator="nodeGenerator")
    @GenericGenerator(name="nodeGenerator", strategy="foreign", parameters={@Parameter(name="property", value="node")})
    public int getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(int id) {
        this.m_nodeId = id;
    }

    @Column(name="criticalpathip", nullable=false)
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    public InetAddress getCriticalPathIp() {
        return this.m_criticalPathIp;
    }

    public void setCriticalPathIp(InetAddress criticalPathIp) {
        this.m_criticalPathIp = criticalPathIp;
    }

    @Column(name="criticalpathservicename")
    public String getCriticalPathServiceName() {
        return this.m_criticalPathServiceName;
    }

    public void setCriticalPathServiceName(String criticalPathServiceName) {
        this.m_criticalPathServiceName = criticalPathServiceName;
    }
}

