/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.Collection;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.GeronimoConnectionEventListener;

public class ManagedConnectionInfo {
    private ManagedConnectionFactory managedConnectionFactory;
    private ConnectionRequestInfo connectionRequestInfo;
    private Subject subject;
    private ManagedConnection managedConnection;
    private XAResource xares;
    private long lastUsed;
    private ConnectionInterceptor poolInterceptor;
    private GeronimoConnectionEventListener listener;

    public ManagedConnectionInfo(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) {
        this.managedConnectionFactory = managedConnectionFactory;
        this.connectionRequestInfo = connectionRequestInfo;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public void setManagedConnectionFactory(ManagedConnectionFactory managedConnectionFactory) {
        this.managedConnectionFactory = managedConnectionFactory;
    }

    public ConnectionRequestInfo getConnectionRequestInfo() {
        return this.connectionRequestInfo;
    }

    public void setConnectionRequestInfo(ConnectionRequestInfo cri) {
        this.connectionRequestInfo = cri;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public ManagedConnection getManagedConnection() {
        return this.managedConnection;
    }

    public void setManagedConnection(ManagedConnection managedConnection) {
        assert (this.managedConnection == null);
        this.managedConnection = managedConnection;
    }

    public XAResource getXAResource() {
        return this.xares;
    }

    public void setXAResource(XAResource xares) {
        this.xares = xares;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public void setPoolInterceptor(ConnectionInterceptor poolInterceptor) {
        this.poolInterceptor = poolInterceptor;
    }

    public ConnectionInterceptor getPoolInterceptor() {
        return this.poolInterceptor;
    }

    public void setConnectionEventListener(GeronimoConnectionEventListener listener) {
        this.listener = listener;
    }

    public void addConnectionHandle(ConnectionInfo connectionInfo) {
        this.listener.addConnectionInfo(connectionInfo);
    }

    public void removeConnectionHandle(ConnectionInfo connectionInfo) {
        this.listener.removeConnectionInfo(connectionInfo);
    }

    public boolean hasConnectionHandles() {
        return this.listener.hasConnectionInfos();
    }

    public void clearConnectionHandles() {
        this.listener.clearConnectionInfos();
    }

    public Collection<ConnectionInfo> getConnectionInfos() {
        return this.listener.getConnectionInfos();
    }

    public boolean securityMatches(ManagedConnectionInfo other) {
        return (this.subject == null ? other.getSubject() == null : this.subject.equals(other.getSubject())) && (this.connectionRequestInfo == null ? other.getConnectionRequestInfo() == null : this.connectionRequestInfo.equals((Object)other.getConnectionRequestInfo()));
    }

    public boolean hasConnectionInfo(ConnectionInfo connectionInfo) {
        return this.listener.hasConnectionInfo(connectionInfo);
    }

    public boolean isFirstConnectionInfo(ConnectionInfo connectionInfo) {
        return this.listener.isFirstConnectionInfo(connectionInfo);
    }

    public String toString() {
        return "ManagedConnectionInfo: " + super.toString() + ". mc: " + this.managedConnection + "]";
    }
}

