/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtxrNeighborTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(MtxrNeighborTableTracker.class);
    public static final SnmpObjId MTXR_NEIGHBOR_INTERFACE_ID_OID = SnmpObjId.get((String)".1.3.6.1.4.1.14988.1.1.11.1.1.8");
    public static final String MTXR_NEIGHBOR_INTERFACE_ID = "mtxrNeighborInterfaceID";
    public static final SnmpObjId[] s_mtxrneiinterfaceid_elemList = new SnmpObjId[]{MTXR_NEIGHBOR_INTERFACE_ID_OID};

    public MtxrNeighborTableTracker() {
        super(s_mtxrneiinterfaceid_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new MtxrNeighborRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processMtxrIndexPortRow((MtxrNeighborRow)row);
    }

    public void processMtxrIndexPortRow(MtxrNeighborRow row) {
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(MTXR_NEIGHBOR_INTERFACE_ID_OID) + "." + row.getInstance().toString(), MTXR_NEIGHBOR_INTERFACE_ID, row.getMtxrNeighborInterfaceId());
    }

    public static class MtxrNeighborRow
    extends SnmpRowResult {
        public MtxrNeighborRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getMtxrNeighborIndex() {
            return this.getInstance().getSubIdAt(0);
        }

        public Integer getMtxrNeighborInterfaceId() {
            return this.getValue(MTXR_NEIGHBOR_INTERFACE_ID_OID).toInt();
        }
    }
}

