/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.dto;

import java.util.Date;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.collection.dto.NodeLevelResourceDTO;
import org.opennms.netmgt.collection.support.builder.InterfaceLevelResource;

@XmlRootElement(name="interface-level-resource")
@XmlAccessorType(value=XmlAccessType.NONE)
public class InterfaceLevelResourceDTO {
    @XmlElement(name="node-level-resource")
    private NodeLevelResourceDTO parent;
    @XmlAttribute(name="if-name")
    private String ifName;
    @XmlAttribute(name="timestamp")
    private Date timestamp;

    public InterfaceLevelResourceDTO() {
    }

    public InterfaceLevelResourceDTO(InterfaceLevelResource resource) {
        this.parent = new NodeLevelResourceDTO(resource.getParent());
        this.ifName = resource.getIfName();
        this.timestamp = resource.getTimestamp();
    }

    public String toString() {
        return String.format("InterfaceLevelResourceDTO[parent=%s, ifName=%s]", this.parent, this.ifName);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.ifName, this.timestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterfaceLevelResourceDTO)) {
            return false;
        }
        InterfaceLevelResourceDTO other = (InterfaceLevelResourceDTO)obj;
        return Objects.equals(this.parent, other.parent) && Objects.equals(this.ifName, other.ifName) && Objects.equals(this.timestamp, other.timestamp);
    }

    public InterfaceLevelResource toResource() {
        InterfaceLevelResource resource = new InterfaceLevelResource(this.parent.toResource(), this.ifName);
        resource.setTimestamp(this.timestamp);
        return resource;
    }
}

