/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors.support;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;

public class LoopPlugin {
    private static final String m_protocolName = "LOOP";

    public String getProtocolName() {
        return m_protocolName;
    }

    public boolean isProtocolSupported(InetAddress address) {
        return this.isProtocolSupported(address, null);
    }

    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        if (qualifiers == null) {
            return false;
        }
        String ipMatch = this.getIpMatch(qualifiers);
        if (IPLike.matches((String)InetAddressUtils.str((InetAddress)address), (String)ipMatch)) {
            return this.isSupported(qualifiers);
        }
        return false;
    }

    private boolean isSupported(Map<String, Object> parameters) {
        return ParameterMap.getKeyedString(parameters, (String)"is-supported", (String)"false").equalsIgnoreCase("true");
    }

    private String getIpMatch(Map<String, Object> parameters) {
        return ParameterMap.getKeyedString(parameters, (String)"ip-match", (String)"*.*.*.*");
    }
}

