/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1.smime;

import java.util.Enumeration;
import java.util.Vector;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERObjectIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.cms.Attribute;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.asn1.smime.SMIMECapability;

public class SMIMECapabilities
extends ASN1Encodable {
    public static final DERObjectIdentifier preferSignedData = PKCSObjectIdentifiers.preferSignedData;
    public static final DERObjectIdentifier canNotDecryptAny = PKCSObjectIdentifiers.canNotDecryptAny;
    public static final DERObjectIdentifier sMIMECapabilitesVersions = PKCSObjectIdentifiers.sMIMECapabilitiesVersions;
    public static final DERObjectIdentifier dES_CBC = new DERObjectIdentifier("1.3.14.3.2.7");
    public static final DERObjectIdentifier dES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC;
    public static final DERObjectIdentifier rC2_CBC = PKCSObjectIdentifiers.RC2_CBC;
    private ASN1Sequence capabilities;

    public static SMIMECapabilities getInstance(Object object) {
        if (object == null || object instanceof SMIMECapabilities) {
            return (SMIMECapabilities)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SMIMECapabilities((ASN1Sequence)object);
        }
        if (object instanceof Attribute) {
            return new SMIMECapabilities((ASN1Sequence)((Attribute)object).getAttrValues().getObjectAt(0));
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public SMIMECapabilities(ASN1Sequence aSN1Sequence) {
        this.capabilities = aSN1Sequence;
    }

    public Vector getCapabilities(DERObjectIdentifier dERObjectIdentifier) {
        Enumeration enumeration = this.capabilities.getObjects();
        Vector<SMIMECapability> vector = new Vector<SMIMECapability>();
        if (dERObjectIdentifier == null) {
            while (enumeration.hasMoreElements()) {
                SMIMECapability sMIMECapability = SMIMECapability.getInstance(enumeration.nextElement());
                vector.addElement(sMIMECapability);
            }
        } else {
            while (enumeration.hasMoreElements()) {
                SMIMECapability sMIMECapability = SMIMECapability.getInstance(enumeration.nextElement());
                if (!dERObjectIdentifier.equals(sMIMECapability.getCapabilityID())) continue;
                vector.addElement(sMIMECapability);
            }
        }
        return vector;
    }

    public DERObject toASN1Object() {
        return this.capabilities;
    }
}

