/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.webservice.handler;

import java.io.Serializable;
import net.jradius.dictionary.Attr_AuthType;
import net.jradius.dictionary.vsa_jradius.Attr_JRadiusSessionId;
import net.jradius.handler.RadiusSessionHandler;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.server.JRadiusRequest;
import net.jradius.session.JRadiusSession;
import net.jradius.webservice.OTPProxyRequest;
import net.jradius.webservice.WebServiceListener;

public class OTPProxyPostAuthHandler
extends RadiusSessionHandler {
    private String listenerBean = "otpListener";

    public boolean handle(JRadiusRequest request) throws Exception {
        JRadiusSession session = request.getSession();
        if (session == null) {
            return this.noSessionFound(request);
        }
        RadiusPacket req = request.getRequestPacket();
        RadiusPacket rep = request.getReplyPacket();
        AttributeList ci = request.getConfigItems();
        String username = (String)req.getAttributeValue(1L);
        if (request.getApplicationContext() == null) {
            RadiusLog.error((String)(((Object)((Object)this)).getClass().getName() + " can only run when configured with Spring"));
            return false;
        }
        WebServiceListener wsListener = (WebServiceListener)((Object)request.getApplicationContext().getBean(this.listenerBean));
        if (wsListener == null) {
            return false;
        }
        OTPProxyRequest otpRequest = (OTPProxyRequest)wsListener.get(username);
        if (otpRequest == null) {
            return false;
        }
        req.addAttribute((RadiusAttribute)new Attr_JRadiusSessionId((Serializable)((Object)session.getSessionKey())));
        otpRequest.setAccessRequest((RadiusRequest)req);
        RadiusResponse resp = otpRequest.getAccessResponse();
        if (resp == null) {
            ci.add((RadiusAttribute)new Attr_AuthType((Serializable)Attr_AuthType.Reject));
            request.setReturnValue(0);
            return true;
        }
        RadiusLog.debug((String)("------------------------------------------------\nOTP Proxy Response:\n" + resp.toString() + "------------------------------------------------\n"));
        if (resp instanceof AccessAccept) {
            AttributeList attrs = resp.getAttributes();
            attrs.remove(25L);
            attrs.remove(24L);
            attrs.remove(79L);
            attrs.remove(80L);
            rep.addAttributes(attrs);
            return false;
        }
        ci.add((RadiusAttribute)new Attr_AuthType((Serializable)Attr_AuthType.Reject));
        request.setReturnValue(0);
        return true;
    }
}

