/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.netmgt.enlinkd.service.api.Bridge;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgePortWithMacs;
import org.opennms.netmgt.enlinkd.service.api.Topology;

public class BridgeForwardingTable
implements Topology {
    private final Bridge m_bridge;
    private final Set<BridgeForwardingTableEntry> m_entries;
    private Map<String, BridgePort> m_mactoport = new HashMap<String, BridgePort>();
    private Map<String, Set<BridgePort>> m_duplicated = new HashMap<String, Set<BridgePort>>();
    private final Set<BridgePortWithMacs> m_porttomac = new HashSet<BridgePortWithMacs>();

    public BridgeForwardingTable(Bridge bridge, Set<BridgeForwardingTableEntry> entries) {
        this.m_bridge = bridge;
        this.m_entries = entries;
    }

    public Set<BridgePortWithMacs> getPorttomac() {
        return this.m_porttomac;
    }

    public BridgePortWithMacs getBridgePortWithMacs(BridgePort port) {
        for (BridgePortWithMacs bpmx : this.m_porttomac) {
            if (!bpmx.getPort().equals(port)) continue;
            return bpmx;
        }
        return null;
    }

    public Map<String, BridgePort> getMactoport() {
        return this.m_mactoport;
    }

    public void setMactoport(Map<String, BridgePort> mactoport) {
        this.m_mactoport = mactoport;
    }

    public Map<String, Set<BridgePort>> getDuplicated() {
        return this.m_duplicated;
    }

    public void setDuplicated(Map<String, Set<BridgePort>> duplicated) {
        this.m_duplicated = duplicated;
    }

    public Set<BridgeForwardingTableEntry> getEntries() {
        return this.m_entries;
    }

    public int getBftSize() {
        return this.m_entries.size();
    }

    public Set<String> getBftMacs() {
        return this.m_mactoport.keySet();
    }

    public Integer getNodeId() {
        return this.m_bridge.getNodeId();
    }

    public Set<String> getIdentifiers() {
        return this.m_bridge.getIdentifiers();
    }

    public Bridge getBridge() {
        return this.m_bridge;
    }

    public Integer getRootBridgePort() {
        return this.m_bridge.getRootPort();
    }

    public BridgePort getRootPort() {
        return this.getPort(this.m_bridge.getRootPort());
    }

    public BridgePort getPort(Integer bp) {
        BridgePortWithMacs bpwm = (BridgePortWithMacs)this.m_porttomac.stream().filter(bpm -> Objects.equals(bpm.getPort().getBridgePort(), bp)).iterator().next();
        if (bpwm == null) {
            return null;
        }
        return bpwm.getPort();
    }

    public void setRootPort(Integer rootPort) {
        this.m_bridge.setRootPort(rootPort);
    }

    @Override
    public String printTopology() {
        ArrayList<Topology> topologies = new ArrayList<Topology>();
        topologies.add(this.m_bridge);
        topologies.addAll(this.m_entries);
        return topologies.stream().map(Topology::printTopology).collect(Collectors.joining("\n"));
    }
}

