/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.daemon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.opennms.core.ipc.twin.api.TwinPublisher;
import org.opennms.netmgt.telemetry.config.model.ConnectorTwinConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(LocationPublisher.class);
    private final String location;
    private final TwinPublisher twinPublisher;
    private final ReentrantLock lock = new ReentrantLock();
    private TwinPublisher.Session<ConnectorTwinConfig> session;
    private final Map<String, ConnectorTwinConfig.ConnectorConfig> configs = new HashMap<String, ConnectorTwinConfig.ConnectorConfig>();
    private String queueName;

    public LocationPublisher(String location, TwinPublisher twinPublisher) {
        this.location = location;
        this.twinPublisher = twinPublisher;
        if (this.session == null) {
            try {
                this.session = twinPublisher.register(ConnectorTwinConfig.CONNECTOR_KEY, ConnectorTwinConfig.class, location);
            }
            catch (IOException e) {
                LOG.error("Failed to create  session for {}: {}", new Object[]{location, e.getMessage(), e});
            }
        }
    }

    public void addConfigAndPublish(ConnectorTwinConfig.ConnectorConfig cfg) throws IOException {
        this.lock.lock();
        try {
            this.configs.put(cfg.getConnectionKey(), cfg);
            this.publishCurrentConfigs();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeConfigAndPublish(String connectionKey) throws IOException {
        this.lock.lock();
        try {
            if (this.configs.remove(connectionKey) != null) {
                this.publishCurrentConfigs();
                if (this.configs.isEmpty()) {
                    this.closeSession();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void publishCurrentConfigs() throws IOException {
        ConnectorTwinConfig confReq = new ConnectorTwinConfig(this.queueName, new ArrayList<ConnectorTwinConfig.ConnectorConfig>(this.configs.values()));
        this.session.publish((Object)confReq);
    }

    private void closeSession() throws IOException {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public void forceClose() {
        this.lock.lock();
        try {
            this.configs.clear();
            this.closeSession();
        }
        catch (IOException e) {
            LOG.error("Failed to close session for {}: {}", new Object[]{this.location, e.getMessage(), e});
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasConfigs() {
        this.lock.lock();
        try {
            boolean bl = !this.configs.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setQueueName(String queueName) {
        this.lock.lock();
        try {
            if (queueName != null) {
                this.queueName = queueName;
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

