/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter;

import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GrpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcClient.class);
    private final String host;
    private final String tlsCertPath;
    private final boolean tlsEnabled;
    private ManagedChannel channel;
    private final ClientInterceptor clientInterceptor;
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public GrpcClient(String host, String tlsCertPath, boolean tlsEnabled, ClientInterceptor clientInterceptor) {
        this.host = Objects.requireNonNull(host);
        this.tlsCertPath = tlsCertPath;
        this.tlsEnabled = tlsEnabled;
        this.clientInterceptor = clientInterceptor;
    }

    public ConnectivityState getChannelState() {
        return this.channel != null ? this.channel.getState(true) : ConnectivityState.SHUTDOWN;
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public String getHost() {
        return this.host;
    }

    public boolean getStopped() {
        return this.stopped.get();
    }

    public synchronized void startGrpcConnection() throws SSLException {
        if (this.getChannelState().equals((Object)ConnectivityState.READY)) {
            LOG.info("Grpc Channel already connected and in ready state!");
            return;
        }
        NettyChannelBuilder channelBuilder = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)this.host).intercept(new ClientInterceptor[]{this.clientInterceptor})).keepAliveWithoutCalls(true);
        if (this.tlsEnabled && this.tlsCertPath != null && !this.tlsCertPath.isBlank()) {
            this.channel = channelBuilder.useTransportSecurity().sslContext(GrpcSslContexts.forClient().trustManager(new File(this.tlsCertPath)).build()).build();
            LOG.info("TLS enabled with cert at {}", (Object)this.tlsCertPath);
        } else if (this.tlsEnabled) {
            this.channel = channelBuilder.useTransportSecurity().build();
            LOG.info("TLS enabled with certs from system store");
        } else {
            this.channel = channelBuilder.usePlaintext().build();
            LOG.info("TLS disabled, using plain text");
        }
        LOG.info("Grpc client started connection to {}", (Object)this.host);
    }

    public synchronized void stopGrpcConnection() {
        if (this.channel != null) {
            this.channel.shutdownNow();
        }
        this.stopped.set(true);
        LOG.info("Grpc client stopped for host {} ", (Object)this.host);
    }
}

