/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.criteria;

import java.util.Objects;
import org.opennms.core.criteria.restrictions.Restriction;

public class Alias {
    private final String m_associationPath;
    private final String m_alias;
    private final JoinType m_type;
    private Restriction m_joinCondition;

    public Alias(String associationPath, String alias, JoinType type, Restriction joinCondition) {
        this.m_alias = alias.intern();
        this.m_associationPath = associationPath.intern();
        this.m_type = type;
        this.m_joinCondition = joinCondition;
    }

    public Alias(String associationPath, String alias, JoinType type) {
        this(associationPath, alias, type, null);
    }

    public String getAlias() {
        return this.m_alias;
    }

    public String getAssociationPath() {
        return this.m_associationPath;
    }

    public JoinType getType() {
        return this.m_type;
    }

    public boolean hasJoinCondition() {
        return this.m_joinCondition != null;
    }

    public Restriction getJoinCondition() {
        return this.m_joinCondition;
    }

    public void setJoinCondition(Restriction joinCondition) {
        this.m_joinCondition = joinCondition;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_alias, this.m_associationPath, this.m_type, this.m_joinCondition});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alias)) {
            return false;
        }
        Alias that = (Alias)obj;
        return Objects.equals(this.m_alias, that.m_alias) && Objects.equals(this.m_associationPath, that.m_associationPath) && Objects.equals((Object)this.m_type, (Object)that.m_type) && Objects.equals(this.m_joinCondition, that.m_joinCondition);
    }

    public String toString() {
        return "Alias [associationPath=" + this.m_associationPath + ", alias=" + this.m_alias + ", type=" + String.valueOf((Object)this.m_type) + ", joinCondition=" + String.valueOf(this.m_joinCondition) + "]";
    }

    public static enum JoinType {
        LEFT_JOIN,
        INNER_JOIN,
        FULL_JOIN;

    }

    public static interface AliasVisitor {
        public void visitAlias(String var1);

        public void visitAssociationPath(String var1);

        public void visitType(JoinType var1);
    }
}

