/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator;

import java.util.function.Consumer;
import org.opennms.enlinkd.generator.TopologyContext;
import org.opennms.enlinkd.generator.TopologyPersister;
import org.opennms.enlinkd.generator.TopologySettings;
import org.opennms.enlinkd.generator.protocol.BridgeProtocol;
import org.opennms.enlinkd.generator.protocol.CdpProtocol;
import org.opennms.enlinkd.generator.protocol.IsIsProtocol;
import org.opennms.enlinkd.generator.protocol.LldpProtocol;
import org.opennms.enlinkd.generator.protocol.OspfProtocol;
import org.opennms.enlinkd.generator.protocol.UserDefinedProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyGenerator {
    public static final String CATEGORY_NAME = "GeneratedNode";
    private TopologyContext topologyContext;

    public static TopologyGeneratorBuilder builder() {
        return new TopologyGeneratorBuilder();
    }

    private TopologyGenerator(TopologyPersister persister, ProgressCallback progressCallback) {
        this.topologyContext = new TopologyContext(progressCallback, persister);
    }

    public void generateTopology(TopologySettings topologySettings) {
        org.opennms.enlinkd.generator.protocol.Protocol protocol = this.getProtocol(topologySettings);
        this.deleteTopology();
        protocol.createAndPersistNetwork();
    }

    public void deleteTopology() {
        this.topologyContext.getTopologyPersister().deleteTopology();
    }

    private org.opennms.enlinkd.generator.protocol.Protocol getProtocol(TopologySettings topologySettings) {
        Protocol protocol = topologySettings.getProtocol();
        if (Protocol.cdp == protocol) {
            return new CdpProtocol(topologySettings, this.topologyContext);
        }
        if (Protocol.isis == protocol) {
            return new IsIsProtocol(topologySettings, this.topologyContext);
        }
        if (Protocol.lldp == protocol) {
            return new LldpProtocol(topologySettings, this.topologyContext);
        }
        if (Protocol.ospf == protocol) {
            return new OspfProtocol(topologySettings, this.topologyContext);
        }
        if (Protocol.bridge == protocol) {
            return new BridgeProtocol(topologySettings, this.topologyContext);
        }
        if (Protocol.userdefined == protocol) {
            return new UserDefinedProtocol(topologySettings, this.topologyContext);
        }
        throw new IllegalArgumentException("Don't know this protocol: " + String.valueOf((Object)topologySettings.getProtocol()));
    }

    public static class TopologyGeneratorBuilder {
        private TopologyPersister persister;
        private ProgressCallback progressCallback;

        private TopologyGeneratorBuilder() {
        }

        public TopologyGeneratorBuilder persister(TopologyPersister persister) {
            this.persister = persister;
            return this;
        }

        public TopologyGeneratorBuilder progressCallback(ProgressCallback progressCallback) {
            this.progressCallback = progressCallback;
            return this;
        }

        public TopologyGenerator build() {
            if (this.progressCallback == null) {
                Logger log = LoggerFactory.getLogger(TopologyGenerator.class);
                this.progressCallback = new ProgressCallback(arg_0 -> ((Logger)log).info(arg_0));
            }
            return new TopologyGenerator(this.persister, this.progressCallback);
        }
    }

    public static class ProgressCallback {
        private Consumer<String> consumer;

        public ProgressCallback(Consumer<String> consumer) {
            this.consumer = consumer;
        }

        public void currentProgress(String progress) {
            this.consumer.accept(progress);
        }

        public void currentProgress(String progress, Object ... args) {
            this.currentProgress(String.format(progress, args));
        }
    }

    public static enum Protocol {
        cdp,
        isis,
        lldp,
        ospf,
        bridge,
        userdefined;

    }

    public static enum Topology {
        ring,
        random,
        complete;

    }
}

