/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.jobs;

import java.util.Collection;
import java.util.Objects;
import org.opennms.features.jmxconfiggenerator.graphs.GraphConfigGenerator;
import org.opennms.features.jmxconfiggenerator.graphs.JmxConfigReader;
import org.opennms.features.jmxconfiggenerator.log.LogAdapter;
import org.opennms.features.jmxconfiggenerator.log.Slf4jLogAdapter;
import org.opennms.features.vaadin.jmxconfiggenerator.JmxConfigGeneratorUI;
import org.opennms.features.vaadin.jmxconfiggenerator.data.UiModel;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.Task;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.TaskRunException;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;

public class GenerateConfigsJob
implements Task {
    private final UiModel model;
    private final JmxConfigGeneratorUI ui;

    public GenerateConfigsJob(JmxConfigGeneratorUI ui, UiModel model) {
        this.ui = Objects.requireNonNull(ui);
        this.model = Objects.requireNonNull(model);
    }

    public Void execute() throws TaskRunException {
        GraphConfigGenerator graphConfigGenerator = new GraphConfigGenerator((LogAdapter)new Slf4jLogAdapter(GraphConfigGenerator.class));
        Collection reports = new JmxConfigReader((LogAdapter)new Slf4jLogAdapter(JmxConfigReader.class)).generateReportsByJmxDatacollectionConfig(this.model.getOutputConfig());
        this.model.setSnmpGraphProperties(graphConfigGenerator.generateSnmpGraph(reports));
        this.model.updateOutput();
        return null;
    }

    public void onSuccess(Object result) {
        this.ui.updateView(UiState.ResultView);
    }

    @Override
    public void onError() {
    }

    @Override
    public JmxConfigGeneratorUI getUI() {
        if (!this.ui.isAttached()) {
            throw new IllegalStateException("UI " + this.ui.getUIId() + " is detached.");
        }
        return this.ui;
    }
}

