/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.KeepalivePacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.NotificationPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.OpenPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.UnknownPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.UpdatePacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;

public class Header {
    public static final int SIZE = 19;
    private static final byte[] EXPECTED_MARKER = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public final int length;
    public final Type type;

    public Header(ByteBuf buffer) throws InvalidPacketException {
        byte[] marker = BufferUtils.bytes((ByteBuf)buffer, (int)16);
        if (!Arrays.equals(marker, EXPECTED_MARKER)) {
            throw new InvalidPacketException(buffer, "Invalid BGP packet marker", new Object[0]);
        }
        this.length = BufferUtils.uint16((ByteBuf)buffer);
        this.type = Type.from(buffer);
    }

    public Packet parsePayload(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
        return this.type.parse(this, buffer, flags, peerInfo);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("length", this.length).add("type", (Object)this.type).toString();
    }

    public static enum Type {
        OPEN(OpenPacket::new),
        UPDATE(UpdatePacket::new),
        NOTIFICATION(NotificationPacket::new),
        KEEPALIVE(KeepalivePacket::new),
        UNKNOWN(UnknownPacket::new);

        private final Packet.Parser parser;

        private Type(Packet.Parser parser) {
            this.parser = Objects.requireNonNull(parser);
        }

        private static Type from(ByteBuf buffer) throws InvalidPacketException {
            int type = BufferUtils.uint8((ByteBuf)buffer);
            switch (type) {
                case 1: {
                    return OPEN;
                }
                case 2: {
                    return UPDATE;
                }
                case 3: {
                    return NOTIFICATION;
                }
                case 4: {
                    return KEEPALIVE;
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown BGP Packet Type: {}", (Object)type);
            return UNKNOWN;
        }

        private Packet parse(Header header, ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
            return this.parser.parse(header, buffer, flags, peerInfo);
        }
    }
}

