/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.offheap;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.opennms.core.ipc.sink.api.ReadFailedException;
import org.opennms.core.ipc.sink.offheap.DataBlock;
import org.opennms.core.ipc.sink.offheap.OffHeapDataBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryDataBlock<T>
implements DataBlock<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryDataBlock.class);
    private int queueSize;
    private BlockingQueue<Map.Entry<String, T>> queue;
    private String name;
    private DataBlock<T> nextDataBlock;

    public MemoryDataBlock(int queueSize) {
        this.queueSize = queueSize;
        this.queue = new ArrayBlockingQueue<Map.Entry<String, T>>(queueSize, true);
        this.name = System.nanoTime() + "_" + new Random().nextInt(1000);
    }

    @Override
    public synchronized int size() {
        return this.queue.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized boolean enqueue(String key, T message) {
        if (this.size() >= this.queueSize) {
            return false;
        }
        return this.queue.add(new AbstractMap.SimpleImmutableEntry<String, T>(key, message));
    }

    @Override
    public synchronized Map.Entry<String, T> peek() {
        return (Map.Entry)this.queue.peek();
    }

    @Override
    public synchronized Map.Entry<String, T> dequeue() throws InterruptedException {
        return this.queue.take();
    }

    @Override
    public synchronized void notifyNextDataBlock() {
        if (this.nextDataBlock == null) {
            return;
        }
        if (this.nextDataBlock instanceof OffHeapDataBlock) {
            OffHeapDataBlock.executorService.submit(() -> {
                try {
                    ((OffHeapDataBlock)this.nextDataBlock).enableQueue();
                }
                catch (InterruptedException | ReadFailedException e) {
                    LOG.error("Fail to call enableQueue");
                    Thread.currentThread().interrupt();
                }
            });
        }
        this.nextDataBlock = null;
    }

    @Override
    public void setNextDataBlock(DataBlock<T> dataBlock) {
        this.nextDataBlock = Objects.requireNonNull(dataBlock);
    }
}

