/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.jmx.wrappers;

import com.google.common.base.Throwables;
import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.opennms.netmgt.poller.jmx.wrappers.AbstractWrapper;

public class ObjectNameWrapper
extends AbstractWrapper {
    private final ObjectName objectName;

    private ObjectNameWrapper(MBeanServerConnection connection, ObjectName objectName) {
        super(connection);
        this.objectName = objectName;
    }

    @Override
    public Object get(String attributeName) {
        try {
            return this.wrap(this.connection.getAttribute(this.objectName, attributeName));
        }
        catch (IOException | JMException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static ObjectNameWrapper create(MBeanServerConnection connection, ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new IllegalArgumentException("object name must not be a pattern");
        }
        return new ObjectNameWrapper(connection, objectName);
    }

    public static ObjectNameWrapper create(MBeanServerConnection connection, String objectNameString) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(objectNameString);
        }
        catch (MalformedObjectNameException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return ObjectNameWrapper.create(connection, objectName);
    }
}

