/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml.status;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.netmgt.model.OnmsSeverity;

public abstract class GraphMLStatus
implements Status {
    private OnmsSeverity severity;
    private Map<String, String> styleProperties;

    public GraphMLStatus(OnmsSeverity severity, Map<String, String> styleProperties) {
        this.severity = severity;
        this.styleProperties = this.checkStylePropertyNames(styleProperties);
    }

    public GraphMLStatus(OnmsSeverity severity) {
        this.severity = severity;
        this.styleProperties = Maps.newHashMap((Map)Maps.asMap(this.getAllowedStyleProperties(), key -> null));
    }

    protected abstract Set<String> getAllowedStyleProperties();

    public final OnmsSeverity getSeverity() {
        return this.severity;
    }

    public final String computeStatus() {
        return this.severity.getLabel().toLowerCase();
    }

    public Map<String, String> getStatusProperties() {
        return ImmutableMap.of((Object)"status", (Object)this.computeStatus());
    }

    public final Map<String, String> getStyleProperties() {
        return this.styleProperties;
    }

    public final GraphMLStatus severity(OnmsSeverity severity) {
        this.severity = severity;
        return this;
    }

    public final GraphMLStatus style(Map<String, String> style) {
        this.styleProperties.putAll(this.checkStylePropertyNames(style));
        return this;
    }

    public final GraphMLStatus style(String key, String value) {
        this.styleProperties.put(this.checkStylePropertyName(key), value);
        return this;
    }

    protected final Map<String, String> checkStylePropertyNames(Map<String, String> styleProperties) {
        for (String key : styleProperties.keySet()) {
            this.checkStylePropertyName(key);
        }
        return styleProperties;
    }

    private String checkStylePropertyName(String key) {
        Preconditions.checkArgument((boolean)this.getAllowedStyleProperties().contains(key), (String)"Illegal property name: %s - allowed properties are: %s", (Object)key, (Object)Joiner.on((String)", ").join(this.getAllowedStyleProperties()));
        return key;
    }

    protected static OnmsSeverity mergeSeverity(GraphMLStatus s1, GraphMLStatus s2) {
        return s1.getSeverity().isGreaterThan(s2.getSeverity()) ? s1.getSeverity() : s2.getSeverity();
    }

    protected static Map<String, String> mergeStyleProperties(GraphMLStatus s1, GraphMLStatus s2) {
        HashMap styleProperties = Maps.newHashMap();
        for (Map.Entry<String, String> e : s1.getStyleProperties().entrySet()) {
            if (e.getValue() == null) continue;
            styleProperties.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, String> e : s2.getStyleProperties().entrySet()) {
            if (e.getValue() == null) continue;
            styleProperties.put(e.getKey(), e.getValue());
        }
        for (String key : s1.getAllowedStyleProperties()) {
            styleProperties.putIfAbsent(key, null);
        }
        for (String key : s2.getAllowedStyleProperties()) {
            styleProperties.putIfAbsent(key, null);
        }
        return styleProperties;
    }
}

