/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.blob.noop;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opennms.features.distributed.kvstore.api.AbstractAsyncKeyValueStore;
import org.opennms.features.distributed.kvstore.api.BlobStore;
import org.opennms.features.distributed.kvstore.api.KeyValueStore;

public class NoOpBlobStore
extends AbstractAsyncKeyValueStore<byte[]>
implements BlobStore {
    private static final NoOpBlobStore INSTANCE = new NoOpBlobStore();
    private final Collection<KeyValueStore<byte[]>> blobStoreListeners = new CopyOnWriteArrayList<KeyValueStore<byte[]>>();

    public static BlobStore getInstance() {
        return INSTANCE;
    }

    public long put(String key, byte[] value, String context, Integer ttlInSeconds) {
        this.blobStoreListeners.forEach(bl -> bl.put(key, (Object)value, context, ttlInSeconds));
        return 0L;
    }

    public Optional<byte[]> get(String key, String context) {
        this.blobStoreListeners.forEach(bl -> bl.get(key, context));
        return Optional.empty();
    }

    public Optional<Optional<byte[]>> getIfStale(String key, String context, long timestamp) {
        this.blobStoreListeners.forEach(bl -> bl.getIfStale(key, context, timestamp));
        return Optional.empty();
    }

    public OptionalLong getLastUpdated(String key, String context) {
        this.blobStoreListeners.forEach(bl -> bl.getLastUpdated(key, context));
        return OptionalLong.empty();
    }

    public void addListener(KeyValueStore<byte[]> listener) {
        this.blobStoreListeners.add(listener);
    }

    public String getName() {
        return "NoOp";
    }

    public Map<String, byte[]> enumerateContext(String context) {
        return Collections.emptyMap();
    }

    public void delete(String key, String context) {
    }
}

