/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.util;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jolokia.util.EscapeUtil;

public final class OptionsAndArgs {
    private static final Map<String, String> SHORT_OPTS = new HashMap<String, String>();
    private static final Set<String> OPTIONS = new HashSet<String>(Arrays.asList("host", "port", "agentContext", "user", "password", "quiet!", "verbose!", "version!", "executor", "threadNamePrefix", "threadNr", "backlog", "hide!", "protocol", "authMode", "authClass", "authUrl", "authPrincipalSpec", "authIgnoreCerts!", "keystore", "keystorePassword", "useSslClientAuthentication!", "secureSocketProtocol", "keyStoreType", "keyManagerAlgorithm", "trustManagerAlgorithm", "caCert", "serverCert", "serverKey", "serverKeyAlgorithm", "clientPrincipal", "extractClientCheck", "sslProtocol", "sslCipherSuite", "historyMaxEntries", "debug!", "debugMaxEntries", "logHandlerClass", "dispatcherClasses", "maxDepth", "maxCollectionSize", "maxObjects", "restrictorClass", "policyLocation", "mbeanQualifier", "canonicalNaming", "includeStackTrace", "serializeException", "discoveryEnabled", "discoveryAgentUrl", "agentId", "agentDescription", "config", "help!"));
    private static final Set<String> LIST_OPTIONS = new HashSet<String>(Arrays.asList("clientPrincipal", "sslProtocol", "sslCipherSuite"));
    private static final Set<String> COMMANDS_REQUIRING_PID;
    private String command;
    private List<String> extraArgs;
    private Map<String, String> options = new HashMap<String, String>();
    private boolean quiet;
    private boolean verbose;
    private File jarFile;
    private static final Pattern ARGUMENT_PATTERN_WITH_EQUAL;

    public OptionsAndArgs(Set<String> pCommands, String ... pArgs) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < pArgs.length; ++i) {
            String arg = pArgs[i];
            if (arg.startsWith("-")) {
                ArgParsed argParsed = this.parseArgument(pArgs[i], i + 1 <= pArgs.length - 1 ? pArgs[i + 1] : null);
                if (argParsed.skipNext) {
                    ++i;
                }
                String optionsKey = argParsed.option + (LIST_OPTIONS.contains(argParsed.option) ? this.getNextListIndexSuffix(this.options, argParsed.option) : "");
                this.options.put(optionsKey, argParsed.value);
                continue;
            }
            arguments.add(arg);
        }
        this.command = arguments.size() > 0 ? (String)arguments.remove(0) : null;
        String[] args = arguments.size() > 0 ? arguments.toArray(new String[0]) : new String[]{};
        this.init(pCommands, args);
    }

    public String toAgentArg() {
        StringBuilder arg = new StringBuilder();
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            String key = entry.getKey();
            if (key.equals("quiet") || key.equals("verbose")) continue;
            arg.append(key).append("=").append(EscapeUtil.escape(entry.getValue(), "\\\\", ",")).append(",");
        }
        return arg.length() > 0 ? arg.substring(0, arg.length() - 1) : "";
    }

    public String getPid() {
        String arg = this.extraArgs.size() > 0 ? this.extraArgs.get(0) : null;
        return arg != null && arg.matches("^\\d+$") ? arg : null;
    }

    public Pattern getProcessPattern() {
        String arg = this.extraArgs.size() > 0 ? this.extraArgs.get(0) : null;
        try {
            return arg != null && this.getPid() == null ? Pattern.compile(arg, 2) : null;
        }
        catch (PatternSyntaxException exp) {
            throw new IllegalArgumentException("Invalid pattern '" + arg + "' for matching process names", exp);
        }
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getExtraArgs() {
        return this.extraArgs;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public String getPort() {
        String port = this.options.get("port");
        return port != null ? port : "8778";
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean needsVm() {
        return COMMANDS_REQUIRING_PID.contains(this.command) || "list".equals(this.command);
    }

    public String getJarFilePath() {
        return this.jarFile.getAbsolutePath();
    }

    public String getJarFileName() {
        return this.jarFile.getName();
    }

    public static File lookupJarFile() {
        try {
            return new File(OptionsAndArgs.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Error: Cannot lookup jar for this class: " + e, e);
        }
    }

    private ArgParsed parseArgument(String pArg, String pNextArgument) {
        return pArg.startsWith("--") ? this.parseLongOption(pArg, pNextArgument) : this.parseShortOption(pArg, pNextArgument);
    }

    private ArgParsed parseShortOption(String pArg, String pNextArgument) {
        String opt = pArg.substring(1);
        String longOpt = SHORT_OPTS.get(opt);
        if (longOpt == null) {
            throw new IllegalArgumentException("No short option '" + opt + "' known");
        }
        return this.parseArgument("--" + longOpt, pNextArgument);
    }

    private ArgParsed parseLongOption(String pArg, String pNextArgument) {
        String opt = pArg.substring(2);
        String value = null;
        Matcher matcher = ARGUMENT_PATTERN_WITH_EQUAL.matcher(opt);
        if (matcher.matches()) {
            opt = matcher.group(1);
            value = matcher.group(2);
        }
        if (OPTIONS.contains(opt)) {
            this.verifyOptionWithArgument(opt, value, pNextArgument);
            return value != null ? new ArgParsed(opt, value, false) : new ArgParsed(opt, pNextArgument, true);
        }
        if (OPTIONS.contains(opt + "!")) {
            return new ArgParsed(opt, "true", false);
        }
        throw new IllegalArgumentException("Unknown option '" + opt + "'");
    }

    private String getNextListIndexSuffix(Map<String, String> options, String key) {
        if (!options.containsKey(key)) {
            return "";
        }
        int i = 1;
        while (options.containsKey(key + "." + i)) {
            ++i;
        }
        return "." + i;
    }

    private void verifyOptionWithArgument(String pOpt, String pValue, String pNextArgument) {
        if (pValue == null && (pNextArgument == null || pNextArgument.startsWith("-"))) {
            throw new IllegalArgumentException("Option '" + pOpt + "' requires an argument");
        }
    }

    private void init(Set<String> pCommands, String ... pArgs) {
        this.quiet = this.options.containsKey("quiet");
        this.verbose = this.options.containsKey("verbose");
        this.jarFile = OptionsAndArgs.lookupJarFile();
        this.extraArgs = this.checkCommandAndArgs(pCommands, pArgs);
    }

    private void verifyCommandAndArgs(String pCommand, List<String> pArgs) {
        if (COMMANDS_REQUIRING_PID.contains(pCommand) && pArgs.size() == 0) {
            throw new IllegalArgumentException("No process id (PID) or pattern given");
        }
    }

    private List<String> checkCommandAndArgs(Set<String> pCommands, String ... pArgs) {
        ArrayList<String> ret = new ArrayList<String>(Arrays.asList(pArgs));
        if (this.options.containsKey("help")) {
            this.command = "help";
        } else if (this.options.containsKey("version")) {
            this.command = "version";
        } else if (this.command != null && pArgs.length == 0 && !pCommands.contains(this.command)) {
            ret.add(this.command);
            this.command = "toggle";
        } else if (this.command == null && pArgs.length == 0) {
            this.command = "list";
        }
        this.verifyCommandAndArgs(this.command, ret);
        return ret;
    }

    static {
        String[] shortOptsDef = new String[]{"h", "help", "u", "user", "p", "password", "c", "agentContext", "v", "verbose", "q", "quiet"};
        for (int i = 0; i < shortOptsDef.length; i += 2) {
            SHORT_OPTS.put(shortOptsDef[i], shortOptsDef[i + 1]);
        }
        COMMANDS_REQUIRING_PID = new HashSet<String>(Arrays.asList("start", "stop", "toggle", "status"));
        ARGUMENT_PATTERN_WITH_EQUAL = Pattern.compile("([^=]+)=(.*)");
    }

    private static final class ArgParsed {
        private boolean skipNext;
        private String option;
        private String value;

        private ArgParsed(String pOption, String pValue, boolean pSkipNext) {
            this.skipNext = pSkipNext;
            this.option = pOption;
            this.value = pValue;
        }
    }
}

