/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.criteria.restrictions;

import org.opennms.core.criteria.restrictions.BaseRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.RestrictionVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotRestriction
extends BaseRestriction {
    private static final Logger LOG = LoggerFactory.getLogger(NotRestriction.class);
    private final Restriction m_restriction;

    public NotRestriction(Restriction restriction) {
        super(Restriction.RestrictionType.NOT);
        this.m_restriction = restriction;
    }

    public Restriction getRestriction() {
        return this.m_restriction;
    }

    @Override
    public void visit(RestrictionVisitor visitor) {
        visitor.visitNot(this);
        try {
            this.getRestriction().visit(visitor);
        }
        catch (Exception e) {
            LOG.trace("Exception during restriction evaluation: {}", (Object)e.getMessage(), (Object)e);
        }
        visitor.visitNotComplete(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_restriction == null ? 0 : this.m_restriction.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NotRestriction)) {
            return false;
        }
        NotRestriction other = (NotRestriction)obj;
        return !(this.m_restriction == null ? other.m_restriction != null : !this.m_restriction.equals(other.m_restriction));
    }

    @Override
    public String toString() {
        return "NotRestriction [restriction=" + String.valueOf(this.m_restriction) + "]";
    }
}

