/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.joesnmp;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.SnmpException;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpVarBindDTO;
import org.opennms.netmgt.snmp.TrapIdentity;
import org.opennms.netmgt.snmp.TrapInformation;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpValue;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpVarBind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2TrapInformation
extends TrapInformation {
    private static final transient Logger LOG = LoggerFactory.getLogger(V2TrapInformation.class);
    private SnmpPduPacket m_pdu;
    static final int SNMP_SYSUPTIME_OID_INDEX = 0;
    static final int SNMP_TRAP_OID_INDEX = 1;
    static final String SNMP_SYSUPTIME_OID = ".1.3.6.1.2.1.1.3.0";
    static final String EXTREME_SNMP_SYSUPTIME_OID = ".1.3.6.1.2.1.1.3";
    static final String SNMP_TRAP_OID = ".1.3.6.1.6.3.1.1.4.1.0";

    public V2TrapInformation(InetAddress agent, String community, SnmpPduPacket pdu) {
        super(agent, community);
        this.m_pdu = pdu;
    }

    public int getPduLength() {
        return this.m_pdu.getLength();
    }

    public long getTimeStamp() {
        LOG.debug("V2 trap first varbind value: {}", (Object)this.m_pdu.getVarBindAt(0).getValue().toString());
        switch (this.m_pdu.getVarBindAt(0).getValue().typeId()) {
            case 67: {
                LOG.debug("V2 trap first varbind value is of type TIMETICKS (correct)");
                return ((SnmpTimeTicks)this.m_pdu.getVarBindAt(0).getValue()).getValue();
            }
            case 2: {
                LOG.debug("V2 trap first varbind value is of type INTEGER, casting to TIMETICKS");
                return ((SnmpInt32)this.m_pdu.getVarBindAt(0).getValue()).getValue();
            }
        }
        throw new IllegalArgumentException("V2 trap does not have the required first varbind as TIMETICKS - cannot process trap");
    }

    public TrapIdentity getTrapIdentity() {
        SnmpObjectId snmpTrapOid = (SnmpObjectId)this.m_pdu.getVarBindAt(1).getValue();
        SnmpObjectId lastVarBindOid = this.m_pdu.getVarBindAt(this.getPduLength() - 1).getName();
        SnmpSyntax lastVarBindValue = this.m_pdu.getVarBindAt(this.getPduLength() - 1).getValue();
        return new TrapIdentity(SnmpObjId.get((int[])snmpTrapOid.getIdentifiers()), SnmpObjId.get((int[])lastVarBindOid.getIdentifiers()), (SnmpValue)new JoeSnmpValue(lastVarBindValue));
    }

    public InetAddress getTrapAddress() {
        return this.getAgentAddress();
    }

    private SnmpVarBind getVarBindAt(int index) {
        return this.m_pdu.getVarBindAt(index);
    }

    public String getVersion() {
        return "v2";
    }

    public void validate() throws SnmpException {
        if (this.m_pdu.typeId() != -89) {
            throw new SnmpException("Received not SNMPv2 Trap from host " + String.valueOf(this.getTrapAddress()) + "PDU Type = " + this.m_pdu.getCommand());
        }
        LOG.debug("V2 trap numVars or pdu length: {}", (Object)this.getPduLength());
        if (this.getPduLength() < 2) {
            throw new SnmpException("V2 trap from " + String.valueOf(this.getTrapAddress()) + " IGNORED due to not having the required varbinds.  Have " + this.getPduLength() + ", needed 2");
        }
        String varBindName0 = this.m_pdu.getVarBindAt(0).getName().toString();
        String varBindName1 = this.m_pdu.getVarBindAt(1).getName().toString();
        if (varBindName0.equals(EXTREME_SNMP_SYSUPTIME_OID)) {
            LOG.info("V2 trap from {} has been corrected due to the sysUptime.0 varbind not having been sent with a trailing 0.\n\tVarbinds received are : {} and {}", new Object[]{this.getTrapAddress(), varBindName0, varBindName1});
            varBindName0 = SNMP_SYSUPTIME_OID;
        }
        if (!varBindName0.equals(SNMP_SYSUPTIME_OID) || !varBindName1.equals(SNMP_TRAP_OID)) {
            throw new SnmpException("V2 trap from " + String.valueOf(this.getTrapAddress()) + " IGNORED due to not having the required varbinds.\n\tThe first varbind must be sysUpTime.0 and the second snmpTrapOID.0\n\tVarbinds received are : " + varBindName0 + " and " + varBindName1);
        }
    }

    public SnmpVarBindDTO getSnmpVarBindDTO(int i) {
        if (i < 2) {
            if (i == 0) {
                LOG.debug("Skipping processing of varbind it is the sysuptime and the first varbind, it is not processed as a parm per RFC2089");
            } else {
                LOG.debug("Skipping processing of varbind it is the trap OID and the second varbind, it is not processed as a parm per RFC2089");
            }
            return null;
        }
        SnmpObjId name = SnmpObjId.get((int[])this.getVarBindAt(i).getName().getIdentifiers());
        JoeSnmpValue value = new JoeSnmpValue(this.getVarBindAt(i).getValue());
        return new SnmpVarBindDTO(name, (SnmpValue)value);
    }

    protected Integer getRequestId() {
        return this.m_pdu.getRequestId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append("Version=").append(this.getVersion()).append(", Source-Address=").append(this.getTrapAddress().getHostAddress()).append(", Length=").append(this.getPduLength()).append(", Identity=").append(this.getTrapIdentity().toString()).append(", Request-ID=").append(this.getRequestId()).append("]");
        return sb.toString();
    }
}

