/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.joesnmp;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpVarBindDTO;
import org.opennms.netmgt.snmp.TrapIdentity;
import org.opennms.netmgt.snmp.TrapInformation;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpValue;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpVarBind;

public class V1TrapInformation
extends TrapInformation {
    private SnmpPduTrap m_pdu;

    public V1TrapInformation(InetAddress agent, String community, SnmpPduTrap pdu) {
        super(agent, community);
        this.m_pdu = pdu;
    }

    public int getPduLength() {
        return this.m_pdu.getLength();
    }

    public long getTimeStamp() {
        return this.m_pdu.getTimeStamp();
    }

    public TrapIdentity getTrapIdentity() {
        return new TrapIdentity(SnmpObjId.get((int[])this.m_pdu.getEnterprise().getIdentifiers()), this.m_pdu.getGeneric(), this.m_pdu.getSpecific());
    }

    public InetAddress getTrapAddress() {
        return SnmpIPAddress.toInetAddress((SnmpIPAddress)this.m_pdu.getAgentAddress());
    }

    private SnmpVarBind getVarBindAt(int index) {
        return this.m_pdu.getVarBindAt(index);
    }

    public String getVersion() {
        return "v1";
    }

    public SnmpVarBindDTO getSnmpVarBindDTO(int i) {
        SnmpObjId name = SnmpObjId.get((int[])this.getVarBindAt(i).getName().getIdentifiers());
        JoeSnmpValue value = new JoeSnmpValue(this.getVarBindAt(i).getValue());
        return new SnmpVarBindDTO(name, (SnmpValue)value);
    }

    protected Integer getRequestId() {
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append("Version=").append(this.getVersion()).append(", Agent-Addr=").append(this.getTrapAddress().getHostAddress()).append(", Length=").append(this.getPduLength()).append(", Identity=").append(this.getTrapIdentity().toString()).append("]");
        return sb.toString();
    }
}

