/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.foreignsource;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.support.PluginWrapper;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"m_key", "m_value"})
public class PluginParameter
implements Serializable,
Comparable<PluginParameter> {
    private static final long serialVersionUID = -6314596729655404812L;
    @XmlAttribute(name="key")
    private String m_key = null;
    @XmlAttribute(name="value")
    private String m_value = null;
    @XmlTransient
    private PluginConfig m_parent = null;

    public PluginParameter() {
    }

    public PluginParameter(String key, String value) {
        this.m_key = key;
        this.m_value = value;
    }

    public PluginParameter(Map.Entry<String, String> e) {
        this.m_key = e.getKey();
        this.m_value = e.getValue();
    }

    public PluginParameter(PluginConfig pluginConfig, String key, String value) {
        this(key, value);
        this.m_parent = pluginConfig;
    }

    public PluginParameter(PluginConfig pluginConfig, Map.Entry<String, String> set) {
        this(set);
        this.m_parent = pluginConfig;
    }

    public void setPluginConfig(PluginConfig pc) {
        this.m_parent = pc;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public Set<String> getAvailableParameterKeys() {
        Set<String> keys = new TreeSet<String>();
        if (this.m_parent != null) {
            try {
                PluginWrapper pw = new PluginWrapper(this.m_parent.getPluginClass());
                keys = pw.getOptionalKeys();
                for (PluginParameter p : this.m_parent.getParameters()) {
                    if (this.getKey() == null) {
                        if (p.getKey() == null) continue;
                        keys.remove(p.getKey());
                        continue;
                    }
                    if (this.getKey().equals(p.getKey())) continue;
                    keys.remove(p.getKey());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return keys;
    }

    public int hashCode() {
        int prime = 421;
        int result = 1;
        result = 421 * result + (this.m_key == null ? 0 : this.m_key.hashCode());
        result = 421 * result + (this.m_value == null ? 0 : this.m_value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginParameter)) {
            return false;
        }
        PluginParameter other = (PluginParameter)obj;
        if (this.m_key == null ? other.m_key != null : !this.m_key.equals(other.m_key)) {
            return false;
        }
        return !(this.m_value == null ? other.m_value != null : !this.m_value.equals(other.m_value));
    }

    public String toString() {
        return "PluginParameter [key=" + this.m_key + ", value=" + this.m_value + "]";
    }

    @Override
    public int compareTo(PluginParameter other) {
        return new CompareToBuilder().append((Object)this.m_key, (Object)other.m_key).append((Object)this.m_value, (Object)other.m_value).toComparison();
    }
}

