/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.model.Geolocation;

public final class ImmutableGeolocation
implements Geolocation {
    private final String address1;
    private final String address2;
    private final String city;
    private final String state;
    private final String zip;
    private final String country;
    private final Double longitude;
    private final Double latitude;

    private ImmutableGeolocation(Builder builder) {
        this.address1 = builder.address1;
        this.address2 = builder.address2;
        this.city = builder.city;
        this.state = builder.state;
        this.zip = builder.zip;
        this.country = builder.country;
        this.longitude = builder.longitude;
        this.latitude = builder.latitude;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(Geolocation geoLocation) {
        return new Builder(geoLocation);
    }

    public static Geolocation immutableCopy(Geolocation geoLocation) {
        if (geoLocation == null || geoLocation instanceof ImmutableGeolocation) {
            return geoLocation;
        }
        return ImmutableGeolocation.newBuilderFrom(geoLocation).build();
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getZip() {
        return this.zip;
    }

    public String getCountry() {
        return this.country;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableGeolocation that = (ImmutableGeolocation)o;
        return Objects.equals(this.address1, that.address1) && Objects.equals(this.address2, that.address2) && Objects.equals(this.city, that.city) && Objects.equals(this.state, that.state) && Objects.equals(this.zip, that.zip) && Objects.equals(this.country, that.country) && Objects.equals(this.longitude, that.longitude) && Objects.equals(this.latitude, that.latitude);
    }

    public int hashCode() {
        return Objects.hash(this.address1, this.address2, this.city, this.state, this.zip, this.country, this.longitude, this.latitude);
    }

    public String toString() {
        return "ImmutableGeolocation{address1='" + this.address1 + "', address2='" + this.address2 + "', city='" + this.city + "', state='" + this.state + "', zip='" + this.zip + "', country='" + this.country + "', longitude=" + this.longitude + ", latitude=" + this.latitude + "}";
    }

    public static final class Builder {
        private String address1;
        private String address2;
        private String city;
        private String state;
        private String zip;
        private String country;
        private Double longitude;
        private Double latitude;

        private Builder() {
        }

        private Builder(Geolocation geolocation) {
            this.address1 = geolocation.getAddress1();
            this.address2 = geolocation.getAddress2();
            this.city = geolocation.getCity();
            this.state = geolocation.getState();
            this.zip = geolocation.getZip();
            this.country = geolocation.getCountry();
            this.longitude = geolocation.getLongitude();
            this.latitude = geolocation.getLatitude();
        }

        public Builder setAddress1(String address1) {
            this.address1 = address1;
            return this;
        }

        public Builder setAddress2(String address2) {
            this.address2 = address2;
            return this;
        }

        public Builder setCity(String city) {
            this.city = city;
            return this;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public Builder setZip(String zip) {
            this.zip = zip;
            return this;
        }

        public Builder setCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder setLongitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder setLatitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public ImmutableGeolocation build() {
            return new ImmutableGeolocation(this);
        }
    }
}

