/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.offheap;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.nustaq.serialization.FSTConfiguration;
import org.opennms.core.ipc.sink.api.ReadFailedException;
import org.opennms.core.ipc.sink.offheap.DataBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OffHeapDataBlock<T>
implements DataBlock<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(OffHeapDataBlock.class);
    protected static final ForkJoinPool serdesPool = new ForkJoinPool(Math.max(Runtime.getRuntime().availableProcessors() * 2, 4));
    protected static final ExecutorService executorService = Executors.newFixedThreadPool(10);
    protected int queueSize;
    protected BlockingQueue<Map.Entry<String, T>> queue;
    private String name;
    private final Function<T, byte[]> serializer;
    private final Function<byte[], T> deserializer;
    private final Lock diskLock = new ReentrantLock(true);
    private int offHeapQueueSize = -1;
    private Future<Integer> future;
    private boolean restore;
    private DataBlock<T> nextDataBlock;

    abstract void writeData(String var1, byte[] var2);

    abstract byte[] loadData(String var1);

    protected OffHeapDataBlock(String name, int queueSize, Function<T, byte[]> serializer, Function<byte[], T> deserializer, byte[] data) {
        this.serializer = Objects.requireNonNull(serializer);
        this.deserializer = Objects.requireNonNull(deserializer);
        this.queueSize = queueSize;
        if (data == null) {
            this.restore = false;
            this.name = System.nanoTime() + "_" + new Random().nextInt(1000);
            this.queue = new ArrayBlockingQueue<Map.Entry<String, T>>(queueSize, true);
        } else {
            this.restore = true;
            this.name = name;
            SerializedBatch batch = new SerializedBatch(data);
            this.offHeapQueueSize = batch.batchedMessages.size();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized boolean enqueue(String key, T message) {
        try {
            if (this.queue == null || this.future != null) {
                return false;
            }
            this.queue.add(new AbstractMap.SimpleImmutableEntry<String, T>(key, message));
            if (this.queue.remainingCapacity() == 0) {
                this.flushToDisk();
            }
            return true;
        }
        catch (IllegalStateException ex) {
            LOG.error(ex.getMessage());
            return false;
        }
    }

    @Override
    public synchronized Map.Entry<String, T> peek() throws InterruptedException, ReadFailedException {
        this.enableQueue();
        return (Map.Entry)this.queue.peek();
    }

    @Override
    public synchronized Map.Entry<String, T> dequeue() throws InterruptedException, ReadFailedException {
        this.enableQueue();
        return this.queue.take();
    }

    @Override
    public synchronized void notifyNextDataBlock() {
        if (this.nextDataBlock == null) {
            return;
        }
        if (this.nextDataBlock instanceof OffHeapDataBlock) {
            executorService.submit(() -> {
                try {
                    ((OffHeapDataBlock)this.nextDataBlock).enableQueue();
                }
                catch (InterruptedException | ReadFailedException e) {
                    LOG.error("Fail to notify next block.");
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    @Override
    public void setNextDataBlock(DataBlock<T> dataBlock) {
        this.nextDataBlock = Objects.requireNonNull(dataBlock);
    }

    @Override
    public synchronized int size() {
        return this.queue != null ? this.queue.size() : this.offHeapQueueSize;
    }

    private void flushToDisk() {
        if (this.future != null) {
            return;
        }
        this.diskLock.lock();
        this.future = executorService.submit(() -> {
            this.diskLock.lock();
            long start = System.currentTimeMillis();
            try {
                List serializedMessages = (List)((ForkJoinTask)serdesPool.submit(() -> this.queue.parallelStream().map(Map.Entry::getValue).map(this.serializer).collect(Collectors.toList()))).get();
                byte[] serializedBatch = new SerializedBatch(serializedMessages).toBytes();
                this.writeData(this.name, serializedBatch);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("flushToDisk writeData: {} size: {} time: {}", new Object[]{this.name, serializedBatch.length, System.currentTimeMillis() - start});
                }
                this.offHeapQueueSize = this.queue.size();
                this.queue = null;
                Integer n = serializedBatch.length;
                return n;
            }
            finally {
                this.diskLock.unlock();
            }
        });
        this.diskLock.unlock();
    }

    public synchronized void enableQueue() throws ReadFailedException, InterruptedException {
        try {
            if (!this.restore) {
                while (!this.diskLock.tryLock()) {
                    this.wait(10L);
                }
                while (this.future != null && !this.future.isDone()) {
                    this.wait(10L);
                }
                if (this.queue != null) {
                    return;
                }
            } else {
                this.diskLock.lock();
            }
            this.toMemory();
            this.future = null;
            this.restore = false;
        }
        catch (ExecutionException e) {
            throw new ReadFailedException((Throwable)e);
        }
        finally {
            this.diskLock.unlock();
        }
    }

    private void toMemory() throws ExecutionException, InterruptedException {
        this.queue = new ArrayBlockingQueue(this.queueSize, true);
        ArrayBlockingQueue tmpQueue = this.queue;
        long start = System.currentTimeMillis();
        byte[] serializedBatchBytes = this.loadData(this.name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("toMemory loadData: {} time: {}", (Object)this.name, (Object)(System.currentTimeMillis() - start));
        }
        if (serializedBatchBytes == null) {
            LOG.error("Data not found for name: {}", (Object)this.name);
            return;
        }
        ((ForkJoinTask)serdesPool.submit(() -> new SerializedBatch((byte[])serializedBatchBytes).batchedMessages.parallelStream().map(this.deserializer).forEachOrdered(d -> tmpQueue.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(null, d))))).get();
        LOG.debug("toMemory convert: {} time: {}", (Object)this.name, (Object)(System.currentTimeMillis() - start));
        this.offHeapQueueSize = -1;
        this.queue = tmpQueue;
    }

    public static final class SerializedBatch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final FSTConfiguration fstConf = FSTConfiguration.createDefaultConfiguration();
        private final List<byte[]> batchedMessages = new ArrayList<byte[]>();

        SerializedBatch(List<byte[]> messages) {
            this.batchedMessages.addAll(messages);
        }

        SerializedBatch(byte[] bytes) {
            this.batchedMessages.addAll((ArrayList)fstConf.asObject(bytes));
        }

        byte[] toBytes() {
            return fstConf.asByteArray(this.batchedMessages);
        }

        static {
            fstConf.registerClass(new Class[]{ArrayList.class, SerializedBatch.class});
        }
    }
}

