/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.twin.api;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.opennms.core.ipc.twin.api.TwinRequest;

public class TwinUpdate {
    private final TwinRequest twinRequest;
    private byte[] object;
    private int version;
    private boolean isPatch;
    private String sessionId;
    private Map<String, String> tracingInfo = new HashMap<String, String>();

    public TwinUpdate() {
        this.twinRequest = new TwinRequest();
    }

    public TwinUpdate(String key, String location, byte[] object) {
        this.twinRequest = new TwinRequest(key, location);
        this.object = object;
    }

    public TwinUpdate(String key, String location) {
        this.twinRequest = new TwinRequest(key, location);
    }

    public byte[] getObject() {
        return this.object;
    }

    public void setObject(byte[] object) {
        this.object = object;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public boolean isPatch() {
        return this.isPatch;
    }

    public void setPatch(boolean patch) {
        this.isPatch = patch;
    }

    public void setLocation(String location) {
        this.twinRequest.setLocation(location);
    }

    public void setKey(String key) {
        this.twinRequest.setKey(key);
    }

    public String getLocation() {
        return this.twinRequest.getLocation();
    }

    public String getKey() {
        return this.twinRequest.getKey();
    }

    public Map<String, String> getTracingInfo() {
        return this.tracingInfo;
    }

    public void addTracingInfo(String key, String value) {
        this.tracingInfo.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TwinUpdate)) {
            return false;
        }
        TwinUpdate that = (TwinUpdate)o;
        return this.version == that.version && this.isPatch == that.isPatch && Objects.equal((Object)this.twinRequest, (Object)that.twinRequest) && Objects.equal((Object)this.object, (Object)that.object) && Objects.equal((Object)this.sessionId, (Object)that.sessionId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.twinRequest, this.object, this.version, this.isPatch, this.sessionId});
    }

    public String toString() {
        return new StringJoiner(", ", TwinUpdate.class.getSimpleName() + "[", "]").add("twinRequest=" + this.twinRequest).add("object=" + Arrays.toString(this.object)).add("version=" + this.version).add("isPatch=" + this.isPatch).add("sessionId='" + this.sessionId + "'").toString();
    }
}

