/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scheduler;

import java.util.Random;
import org.opennms.netmgt.scheduler.PostponeNecessary;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.ScheduleInterval;
import org.opennms.netmgt.scheduler.ScheduleTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schedule {
    private static final Logger LOG = LoggerFactory.getLogger(Schedule.class);
    private static final Random random = new Random();
    private final ReadyRunnable m_schedulable;
    private final ScheduleInterval m_interval;
    private final ScheduleTimer m_timer;
    private volatile int m_currentExpirationCode;
    private volatile boolean m_scheduled = false;

    public Schedule(ReadyRunnable schedulable, ScheduleInterval interval, ScheduleTimer timer) {
        this.m_schedulable = schedulable;
        this.m_interval = interval;
        this.m_timer = timer;
        this.m_currentExpirationCode = 0;
    }

    public void schedule() {
        this.m_scheduled = true;
        this.schedule(0L);
    }

    private void schedule(long interval) {
        if (interval >= 0L && this.m_scheduled) {
            this.m_timer.schedule(interval, new ScheduleEntry(++this.m_currentExpirationCode));
        }
    }

    public void run() {
        this.m_schedulable.run();
    }

    public void adjustSchedule() {
        this.schedule(this.m_interval.getInterval());
    }

    public void unschedule() {
        this.m_scheduled = false;
        ++this.m_currentExpirationCode;
    }

    public ScheduleInterval getInterval() {
        return this.m_interval;
    }

    public class ScheduleEntry
    implements ReadyRunnable {
        private final int m_expirationCode;

        public ScheduleEntry(int expirationCode) {
            this.m_expirationCode = expirationCode;
        }

        private boolean isExpired() {
            return this.m_expirationCode < Schedule.this.m_currentExpirationCode;
        }

        @Override
        public boolean isReady() {
            return this.isExpired() || Schedule.this.m_schedulable.isReady();
        }

        @Override
        public void run() {
            if (this.isExpired()) {
                LOG.debug("Schedule {} expired.  No need to run.", (Object)this);
                return;
            }
            if (!Schedule.this.m_interval.scheduledSuspension()) {
                try {
                    Schedule.this.run();
                }
                catch (PostponeNecessary e) {
                    Schedule.this.m_timer.schedule((long)random.nextInt(10) * 1000L + 5000L, this);
                    return;
                }
            }
            if (this.isExpired()) {
                LOG.debug("Schedule {} expired.  No need to reschedule.", (Object)this);
                return;
            }
            long interval = Schedule.this.m_interval.getInterval();
            if (interval >= 0L && Schedule.this.m_scheduled) {
                Schedule.this.m_timer.schedule(interval, this);
            }
        }

        public ReadyRunnable getSchedulable() {
            return Schedule.this.m_schedulable;
        }

        public String toString() {
            return "ScheduleEntry[expCode=" + this.m_expirationCode + "] for " + Schedule.this.m_schedulable;
        }
    }
}

