/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scheduler;

import org.opennms.netmgt.scheduler.PriorityReadyRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Executable
implements PriorityReadyRunnable,
Comparable<Executable> {
    private static final Logger LOG = LoggerFactory.getLogger(Executable.class);
    private boolean m_suspend = false;
    private Integer m_priority = 0;

    @Override
    public Integer getPriority() {
        return this.m_priority;
    }

    @Override
    public void setPriority(Integer priority) {
        this.m_priority = priority;
    }

    public Executable() {
    }

    public Executable(int priority) {
        this.m_priority = priority;
    }

    public abstract String getName();

    public abstract void runExecutable();

    @Override
    public void run() {
        if (this.m_suspend) {
            LOG.info("run: suspended {}", (Object)this.getInfo());
            return;
        }
        LOG.info("run: running {}", (Object)this.getInfo());
        this.runExecutable();
    }

    public void suspend() {
        this.m_suspend = true;
    }

    public void wakeUp() {
        this.m_suspend = false;
    }

    @Override
    public String getInfo() {
        return this.getName() + ": Priority: " + this.m_priority;
    }

    @Override
    public int compareTo(Executable o) {
        return this.m_priority - o.getPriority();
    }
}

