/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.dfs;

import java.nio.charset.StandardCharsets;
import jcifs.Encodable;
import jcifs.internal.util.SMBUtil;

public class DfsReferralRequestBuffer
implements Encodable {
    private final int maxReferralLevel;
    private final String path;

    public DfsReferralRequestBuffer(String filename, int maxReferralLevel) {
        this.path = filename;
        this.maxReferralLevel = maxReferralLevel;
    }

    @Override
    public int size() {
        return 4 + 2 * this.path.length();
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.maxReferralLevel, dst, dstIndex);
        byte[] pathBytes = this.path.getBytes(StandardCharsets.UTF_16LE);
        System.arraycopy(pathBytes, 0, dst, dstIndex += 2, pathBytes.length);
        SMBUtil.writeInt2(0L, dst, dstIndex += pathBytes.length);
        return (dstIndex += 2) - start;
    }
}

