/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.ReadonlyContext;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.jexl.OnmsJexlEngine;
import org.opennms.netmgt.dao.jmx.JmxConfigDao;
import org.opennms.netmgt.jmx.JmxUtils;
import org.opennms.netmgt.jmx.connection.JmxConnectionManager;
import org.opennms.netmgt.jmx.connection.JmxConnectors;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionException;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.DefaultConnectionManager;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.jmx.wrappers.ObjectNameWrapper;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(JMXMonitor.class);
    private static final OnmsJexlEngine JEXL_ENGINE = new OnmsJexlEngine();
    public static final String PARAM_BEAN_PREFIX = "beans.";
    public static final String PARAM_TEST_PREFIX = "tests.";
    public static final String PARAM_TEST = "test";
    public static final String PARAM_PORT = "port";
    private final Supplier<JmxConfigDao> jmxConfigDao = Suppliers.memoize(() -> (JmxConfigDao)BeanUtils.getBean((String)"daoContext", (String)"jmxConfigDao", JmxConfigDao.class));

    protected JmxConnectors getConnectionName() {
        return JmxConnectors.DEFAULT;
    }

    public Map<String, Object> getRuntimeAttributes(MonitoredService svc, Map<String, Object> parameters) {
        HashMap<String, String> convert = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            convert.put(entry.getKey(), (String)entry.getValue());
        }
        Map attributes = JmxUtils.getRuntimeAttributes((JmxConfigDao)((JmxConfigDao)this.jmxConfigDao.get()), (String)InetAddressUtils.str((InetAddress)svc.getAddress()), convert);
        return new HashMap<String, Object>(Interpolator.pleaseInterpolate((Map)attributes));
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> map) {
        InetAddress ipv4Addr = svc.getAddress();
        PollStatus serviceStatus = PollStatus.unavailable();
        try {
            final Timer timer = new Timer();
            DefaultConnectionManager connectionManager = new DefaultConnectionManager(ParameterMap.getKeyedInteger(map, (String)"retry", (int)3));
            JmxConnectionManager.RetryCallback retryCallback = new JmxConnectionManager.RetryCallback(){

                public void onRetry() {
                    timer.reset();
                }
            };
            try (JmxServerConnectionWrapper connection = connectionManager.connect(this.getConnectionName(), ipv4Addr, JmxUtils.convertToStringMap(map), retryCallback);){
                if (LOG.isDebugEnabled()) {
                    LOG.debug("connected to JMX server {} on {}", (Object)this.getConnectionName(), (Object)InetAddressUtils.str((InetAddress)ipv4Addr));
                }
                connection.getMBeanServerConnection().getMBeanCount();
                long nanoResponseTime = System.nanoTime() - timer.getStartTime();
                HashMap variables = Maps.newHashMap();
                for (String string : map.keySet()) {
                    if (!string.startsWith(PARAM_BEAN_PREFIX)) continue;
                    String variable = string.substring(PARAM_BEAN_PREFIX.length());
                    String definition = ParameterMap.getKeyedString(map, (String)string, null);
                    variables.put(variable, ObjectNameWrapper.create(connection.getMBeanServerConnection(), definition));
                }
                HashMap tests = Maps.newHashMap();
                for (String key : map.keySet()) {
                    if (!key.startsWith(PARAM_TEST_PREFIX)) continue;
                    String variable = key.substring(PARAM_TEST_PREFIX.length());
                    String definition = ParameterMap.getKeyedString(map, (String)key, null);
                    Expression expression = JEXL_ENGINE.createExpression(definition);
                    tests.put(variable, expression);
                }
                if (map.containsKey(PARAM_TEST)) {
                    String string = ParameterMap.getKeyedString(map, (String)PARAM_TEST, null);
                    Expression expression = JEXL_ENGINE.createExpression(string);
                    tests.put(null, expression);
                }
                ReadonlyContext readonlyContext = new ReadonlyContext((JexlContext)new MapContext((Map)variables));
                serviceStatus = PollStatus.up((Double)((double)nanoResponseTime / 1000000.0));
                for (Map.Entry e : tests.entrySet()) {
                    try {
                        if (((Boolean)((Expression)e.getValue()).evaluate((JexlContext)readonlyContext)).booleanValue()) continue;
                        serviceStatus = PollStatus.down((String)("Test failed: " + (String)e.getKey()));
                    }
                    catch (Throwable t) {
                        LOG.warn("failed to execute test {}", e.getKey(), (Object)t);
                        serviceStatus = PollStatus.down((String)("Test failed: " + (String)e.getKey()));
                    }
                    break;
                }
            }
            catch (JmxServerConnectionException mbse) {
                String reason = "IOException while polling address: " + ipv4Addr;
                LOG.debug(reason, (Throwable)mbse);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
        }
        catch (Throwable e) {
            String reason = "Monitor - failed! " + InetAddressUtils.str((InetAddress)ipv4Addr);
            LOG.debug(reason, e);
            serviceStatus = PollStatus.unavailable((String)reason);
        }
        return serviceStatus;
    }

    static {
        JEXL_ENGINE.white(ObjectNameWrapper.class.getName());
        JEXL_ENGINE.white(String.class.getName());
    }

    private class Timer {
        private long startTime;

        private Timer() {
            this.reset();
        }

        public void reset() {
            this.startTime = System.nanoTime();
        }

        public long getStartTime() {
            return this.startTime;
        }
    }
}

